/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc.locator;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingDelayMeasurer {
    private static final Log LOG = LogFactory.getLog((String)PingDelayMeasurer.class.getName());
    private int pingTimeout;
    protected LindormClientConfig config;

    public PingDelayMeasurer(LindormClientConfig config) {
        this.onConfigChange(config);
    }

    public LindormClientConfig getConf() {
        return this.config;
    }

    public long getPingDelay(LDServerAddress address) throws IOException {
        try {
            InetAddress inetAddress = InetAddress.getByName(address.getHostname());
            long start = System.nanoTime();
            if (inetAddress.isReachable(this.pingTimeout)) {
                return System.nanoTime() - start;
            }
            return this.getDelayByCMD(inetAddress);
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to get ping delay to " + address));
            return Long.MAX_VALUE;
        }
    }

    public void onConfigChange(LindormClientConfig config) {
        this.config = config;
        this.pingTimeout = config.getInt("lindorm.rpc.idc.ping.timeout", 1000);
    }

    public long getDelayByCMD(InetAddress inetAddress) throws IOException {
        String cmd = "ping -c 1 " + inetAddress.getHostName();
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        Pattern pattern = Pattern.compile(".*?([\\d.]+)\\s?ms.*");
        String line = "";
        StringBuilder sb = new StringBuilder();
        while ((line = inputStream.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                float ms = Float.parseFloat(matcher.group(1));
                return (long)(ms * 1000.0f * 1000.0f);
            }
            sb.append(line);
        }
        throw new IOException(inetAddress.getHostName() + " is not reachable, " + sb.toString());
    }
}

