/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.utils.FutureSynchonizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientCompletableFuture<V>
implements Future<V> {
    private FutureSynchonizer syncer = new FutureSynchonizer();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.syncer.await();
        return ((ResultOrException)this.syncer.getValue()).check();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.syncer.await(timeout, unit);
        return ((ResultOrException)this.syncer.getValue()).check();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.syncer.isDone();
    }

    public void complete(V result) {
        this.syncer.done(new ResultOrException(result, null));
    }

    public void completeExceptionally(Throwable exc) {
        this.syncer.done(new ResultOrException(null, exc));
    }

    private static class ResultOrException {
        Object r;
        Throwable e;

        ResultOrException(Object result, Throwable exc) {
            this.r = result;
            this.e = exc;
        }

        <V> V check() throws ExecutionException {
            if (this.e != null) {
                throw new ExecutionException(this.e);
            }
            return (V)this.r;
        }
    }
}

