/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.AdminService;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.acl.Action;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.auth.AuthenticationPassport;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.quota.QuotaConfig;
import com.alibaba.lindorm.client.quota.QuotaLevel;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class LindormAdminService
extends LindormBasicService
implements AdminService {
    private static AtomicInteger adminServiceCount = new AtomicInteger(0);

    public LindormAdminService(LindormClientConfig config) throws LindormException {
        super(config, "AdminService" + adminServiceCount.getAndIncrement());
    }

    public LindormAdminService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    @Override
    public void createNamespace(final String namespace) throws LindormException {
        try {
            LServerCallable<Void> createNamespaceCallable = new LServerCallable<Void>(OperationContext.OperationType.NAMESPACE){

                @Override
                public Void call() throws Exception {
                    this.server.createNamespace(namespace);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(createNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void modifyNamespace(final String namespace, final String attributeKey, final byte[] attributeValue) throws LindormException {
        try {
            LServerCallable<Void> modifyNamespaceCallable = new LServerCallable<Void>(OperationContext.OperationType.NAMESPACE){

                @Override
                public Void call() throws Exception {
                    this.server.modifyNamespace(namespace, attributeKey, attributeValue);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void removeNamespace(final String namespace) throws LindormException {
        try {
            LServerCallable<Void> removeNamespaceCallable = new LServerCallable<Void>(OperationContext.OperationType.NAMESPACE){

                @Override
                public Void call() throws Exception {
                    this.server.removeNamespace(namespace);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(removeNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<String> listTablesByNamespace(final String namespace) throws LindormException {
        try {
            LServerCallable<List<String>> listTablesByNamespaceCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesByNamespace(namespace);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesByNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<Pair<String, byte[]>> listAttributesByNamespace(final String namespace) throws LindormException {
        try {
            LServerCallable<List<Pair<String, byte[]>>> listAttributesByNamespaceCallable = new LServerCallable<List<Pair<String, byte[]>>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<Pair<String, byte[]>> call() throws Exception {
                    return this.server.listAttributesByNamespace(namespace);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listAttributesByNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<Pair<String, byte[]>> listAttributesByNamespace(final String namespace, final boolean highAvailable) throws LindormException {
        try {
            LServerCallable<List<Pair<String, byte[]>>> listAttributesByNamespaceCallable = new LServerCallable<List<Pair<String, byte[]>>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<Pair<String, byte[]>> call() throws Exception {
                    return this.server.listAttributesByNamespace(namespace, highAvailable);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listAttributesByNamespaceCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<String> listNamespaces() throws LindormException {
        try {
            LServerCallable<List<String>> listNamespacesCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listNamespaces();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listNamespacesCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<String> listNamespacesByPrefix(final String prefix) throws LindormException {
        try {
            LServerCallable<List<String>> listNamespacesCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listNamespacesByPrefix(prefix);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listNamespacesCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void createUser(final String user, String password) throws LindormException {
        try {
            final byte[] encodedPassword = AuthenticationPassport.createEncodedPasswordOnStorage(user, password);
            LServerCallable<Void> createUserCallable = new LServerCallable<Void>(OperationContext.OperationType.USER){

                @Override
                public Void call() throws Exception {
                    this.server.createUser(user, encodedPassword);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(createUserCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void removeUser(final String user) throws LindormException {
        try {
            LServerCallable<Void> removeUserCallable = new LServerCallable<Void>(OperationContext.OperationType.USER){

                @Override
                public Void call() throws Exception {
                    this.server.removeUser(user);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(removeUserCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void modifyPassword(final String user, String oldPassword, String newPassword) throws LindormException {
        try {
            final byte[] oldEncodedPassword = oldPassword == null ? null : AuthenticationPassport.createEncodedPasswordOnStorage(user, oldPassword);
            final byte[] newEncodedPassword = AuthenticationPassport.createEncodedPasswordOnStorage(user, newPassword);
            LServerCallable<Void> modifyPasswordCallable = new LServerCallable<Void>(OperationContext.OperationType.USER){

                @Override
                public Void call() throws Exception {
                    this.server.modifyPassword(user, oldEncodedPassword, newEncodedPassword);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyPasswordCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public boolean isUserExists(final String user) throws LindormException {
        try {
            LServerCallable<Boolean> isUserExistsCallable = new LServerCallable<Boolean>(OperationContext.OperationType.USER){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isUserExists(user);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(isUserExistsCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void grant(final String user, final String namespace, final String table, final Action ... actions) throws LindormException {
        try {
            LServerCallable<Void> grantExistsCallable = new LServerCallable<Void>(OperationContext.OperationType.ACL){

                @Override
                public Void call() throws Exception {
                    this.server.grant(user, namespace, table, Action.getStringFromActions(actions));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(grantExistsCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void revoke(final String user, final String namespace, final String table, final Action ... actions) throws LindormException {
        try {
            LServerCallable<Void> revokeExistsCallable = new LServerCallable<Void>(OperationContext.OperationType.ACL){

                @Override
                public Void call() throws Exception {
                    this.server.revoke(user, namespace, table, Action.getStringFromActions(actions));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(revokeExistsCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public String listACL(final String user) throws LindormException {
        try {
            LServerCallable<String> listACLCallable = new LServerCallable<String>(OperationContext.OperationType.ACL){

                @Override
                public String call() throws Exception {
                    return this.server.listACL(user);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listACLCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<String> listUsers() throws LindormException {
        try {
            LServerCallable<List<String>> listUsersCallable = new LServerCallable<List<String>>(OperationContext.OperationType.USER){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listUsers();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listUsersCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void upsertQuota(final QuotaConfig quotaConfig) throws LindormException {
        try {
            LServerCallable<Void> upsertQuotaCallable = new LServerCallable<Void>(OperationContext.OperationType.QUOTA){

                @Override
                public Void call() throws Exception {
                    this.server.upsertQuota(quotaConfig);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(upsertQuotaCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void deleteQuota(final QuotaLevel level, final String name) throws LindormException {
        try {
            LServerCallable<Void> upsertQuotaCallable = new LServerCallable<Void>(OperationContext.OperationType.QUOTA){

                @Override
                public Void call() throws Exception {
                    this.server.deleteQuota(level, name);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(upsertQuotaCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public QuotaConfig getQuota(final QuotaLevel level, final String name) throws LindormException {
        try {
            LServerCallable<QuotaConfig> upsertQuotaCallable = new LServerCallable<QuotaConfig>(OperationContext.OperationType.QUOTA){

                @Override
                public QuotaConfig call() throws Exception {
                    return this.server.getQuota(level, name);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(upsertQuotaCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<QuotaConfig> listQuotas(final QuotaLevel level) throws LindormException {
        try {
            LServerCallable<List<QuotaConfig>> upsertQuotaCallable = new LServerCallable<List<QuotaConfig>>(OperationContext.OperationType.QUOTA){

                @Override
                public List<QuotaConfig> call() throws Exception {
                    return this.server.listQuotas(level);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(upsertQuotaCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<String> listTableNamesByPrefix(final String prefix) throws LindormException {
        try {
            LServerCallable<List<String>> listTableNamesByPrefixCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTableNamesByPrefix(prefix);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTableNamesByPrefixCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void checkAuthentication(final String userName, final byte[] token, final long timestamp, final String uniqueId) throws LindormException {
        try {
            LServerCallable<Void> checkAuthenticationCallable = new LServerCallable<Void>(OperationContext.OperationType.ACL){

                @Override
                public Void call() throws Exception {
                    this.server.checkAuthentication(userName, token, timestamp, uniqueId);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, null).withRetries(checkAuthenticationCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }
}

