/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WColumn;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryPrefixComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBitComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnCountGetFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnRangeFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WDependentColumnFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFamilyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilterList;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFirstKeyOnlyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFuzzyRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WInclusiveStopFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WKeyOnlyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WMultipleColumnPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WNullComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WQualifierFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRandomRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRegexStringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSingleColumnValueExcludeFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSingleColumnValueFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSkipFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSubstringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WTimestampsFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WValueFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WWhileMatchFilter;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.BigDecimalColumnInterpreter;
import org.apache.hadoop.hbase.client.coprocessor.DoubleColumnInterpreter;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;

public class ElementConvertor {
    private static final long DEFAULT_MAX_RESULT_SIZE = -1L;
    private static final Map<String, DataType> INTERPRETER_DATATYPE_MAP = new HashMap<String, DataType>();
    private static final String TABLEMETAVERSION = "TABLEMETAVERSION";
    private static final byte[] TABLEMETAVERSIONBYTES;

    private static WColumn.Type convertTypeToWType(byte type) {
        switch (KeyValue.Type.codeToType((byte)type)) {
            case Minimum: {
                return WColumn.Type.Minimum;
            }
            case Put: {
                return WColumn.Type.Put;
            }
            case Delete: {
                return WColumn.Type.Delete;
            }
            case DeleteColumn: {
                return WColumn.Type.DeleteColumn;
            }
            case DeleteFamily: {
                return WColumn.Type.DeleteFamily;
            }
            case Maximum: {
                return WColumn.Type.Maximum;
            }
        }
        throw new UnsupportedOperationException("Unsupport op type " + KeyValue.Type.codeToType((byte)type));
    }

    private static KeyValue.Type convertWTypeToHType(WColumn.Type type) {
        switch (type) {
            case Minimum: {
                return KeyValue.Type.Minimum;
            }
            case Put: {
                return KeyValue.Type.Put;
            }
            case Delete: {
                return KeyValue.Type.Delete;
            }
            case DeleteColumn: {
                return KeyValue.Type.DeleteColumn;
            }
            case DeleteFamily: {
                return KeyValue.Type.DeleteFamily;
            }
            case Maximum: {
                return KeyValue.Type.Maximum;
            }
        }
        throw new UnsupportedOperationException("Unsupport op type " + (Object)((Object)type));
    }

    public static WDelete toLindormDelete(Delete delete) throws IOException {
        ElementConvertor.checkDeleteSupport(delete);
        WDelete wdel = new WDelete(delete.getRow(), delete.getTimeStamp());
        for (Map.Entry entry : delete.getFamilyCellMap().entrySet()) {
            for (Cell kv : (List)entry.getValue()) {
                wdel.addDeleteMarker(new WColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv), kv.getTimestamp(), ElementConvertor.convertTypeToWType(kv.getTypeByte())));
            }
        }
        return wdel;
    }

    public static List<Delete> toHBaseDeletes(List<WDelete> in) throws IOException {
        ArrayList<Delete> out = new ArrayList<Delete>(in.size());
        for (WDelete delete : in) {
            out.add(ElementConvertor.toHBaseDelete(delete));
        }
        return out;
    }

    public static Delete toHBaseDelete(WDelete in) {
        Delete out = new Delete(in.getRowKey());
        Map<byte[], List<WColumn>> familyMap = in.getFamilyMap();
        for (byte[] family : familyMap.keySet()) {
            for (WColumn columnValue : familyMap.get(family)) {
                byte[] qualifier = columnValue.getQualifier();
                long timestamp = columnValue.getTs();
                if (columnValue.getType() == WColumn.Type.Delete) {
                    out.addColumn(family, qualifier, timestamp);
                    continue;
                }
                if (columnValue.getType() == WColumn.Type.DeleteColumn) {
                    out.addColumns(family, qualifier, timestamp);
                    continue;
                }
                if (columnValue.getType() != WColumn.Type.DeleteFamily) continue;
                out.addFamily(family, timestamp);
            }
        }
        return out;
    }

    private static void checkPutSupport(Put in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Put#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Put#setTTL() is not supported");
        }
        if (!in.getAttributesMap().isEmpty()) {
            throw new IOException("Put#setAttribute() is not supported");
        }
    }

    private static void checkIncrementSupport(Increment in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Increment#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Increment#setTTL() is not supported");
        }
        if (!in.getAttributesMap().isEmpty()) {
            if (in.getAttributesMap().size() > 1 || !in.getAttributesMap().containsKey("_rr_")) {
                throw new IOException("Increment#setAttribute() is not supported");
            }
            if (!Bytes.toBoolean((byte[])((byte[])in.getAttributesMap().get("_rr_")))) {
                throw new IOException("Increment#setAttribute() is not supported");
            }
        }
        if (in.getTimeStamp() != Long.MAX_VALUE) {
            throw new IOException("Timestamp is not supported");
        }
        if (!in.getTimeRange().isAllTime()) {
            throw new IOException("TimeRange is not supported");
        }
    }

    private static void checkAppendSupport(Append in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Append#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Append#setTTL() is not supported");
        }
        if (!in.getAttributesMap().isEmpty()) {
            if (in.getAttributesMap().size() > 1 || !in.getAttributesMap().containsKey("_rr_")) {
                throw new IOException("Append#setAttribute() is not supported");
            }
            if (!Bytes.toBoolean((byte[])((byte[])in.getAttributesMap().get("_rr_")))) {
                throw new IOException("Append#setAttribute() is not supported");
            }
        }
        if (in.getTimeStamp() != Long.MAX_VALUE) {
            throw new IOException("Timestamp is not supported");
        }
    }

    private static void checkDeleteSupport(Delete in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Delete#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Delete#setTTL() is not supported");
        }
        if (!in.getAttributesMap().isEmpty()) {
            throw new IOException("Delete#setAttribute() is not supported");
        }
    }

    public static List<WDelete> toLindormDeleteList(List<Delete> in) throws IOException {
        ArrayList<WDelete> out = new ArrayList<WDelete>(in.size());
        for (Delete delete : in) {
            if (delete == null) continue;
            out.add(ElementConvertor.toLindormDelete(delete));
        }
        return out;
    }

    public static WGet toLindormGet(Get get2) throws IOException {
        ElementConvertor.checkGetRowSupport(get2);
        WGet wget = new WGet(get2.getRow());
        wget.setCacheBlocks(get2.getCacheBlocks());
        wget.setMaxVersions(get2.getMaxVersions());
        TimeRange tr = get2.getTimeRange();
        if (!tr.isAllTime()) {
            wget.setTimeRange(tr.getMin(), tr.getMax());
        }
        wget.setFamilyMap(get2.getFamilyMap());
        wget.setFilter(ElementConvertor.toLindormFilter(get2.getFilter()));
        return wget;
    }

    private static void checkGetRowSupport(Get in) throws IOException {
        if (in.isClosestRowBefore()) {
            throw new IOException("Get#setClosestRowBefore(true) is not supported");
        }
        if (in.getRowOffsetPerColumnFamily() != 0) {
            throw new IOException("Get#setRowOffsetPerColumnFamily() is not supported");
        }
    }

    private static WFilter toLindormFilter(Filter filter) throws IOException {
        if (filter == null) {
            return null;
        }
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            WFilterList wlist = null;
            wlist = filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? new WFilterList(WFilterList.Operator.MUST_PASS_ALL) : new WFilterList(WFilterList.Operator.MUST_PASS_ONE);
            for (Filter childFilter : filterList.getFilters()) {
                wlist.addFilter(ElementConvertor.toLindormFilter(childFilter));
            }
            return wlist;
        }
        if (filter instanceof SingleColumnValueExcludeFilter) {
            SingleColumnValueExcludeFilter sFilter = (SingleColumnValueExcludeFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WSingleColumnValueExcludeFilter(sFilter.getFamily(), sFilter.getQualifier(), op, wComparator);
        }
        if (filter instanceof SingleColumnValueFilter) {
            SingleColumnValueFilter sFilter = (SingleColumnValueFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            WSingleColumnValueFilter wsFilter = new WSingleColumnValueFilter(sFilter.getFamily(), sFilter.getQualifier(), op, wComparator);
            wsFilter.setLatestVersionOnly(sFilter.getLatestVersionOnly());
            wsFilter.setFilterIfMissing(sFilter.getFilterIfMissing());
            return wsFilter;
        }
        if (filter instanceof ColumnCountGetFilter) {
            ColumnCountGetFilter sFilter = (ColumnCountGetFilter)filter;
            return new WColumnCountGetFilter(sFilter.getLimit());
        }
        if (filter instanceof ColumnPrefixFilter) {
            ColumnPrefixFilter sFilter = (ColumnPrefixFilter)filter;
            return new WColumnPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof ColumnRangeFilter) {
            ColumnRangeFilter sFilter = (ColumnRangeFilter)filter;
            return new WColumnRangeFilter(sFilter.getMinColumn(), sFilter.getMinColumnInclusive(), sFilter.getMaxColumn(), sFilter.getMaxColumnInclusive());
        }
        if (filter instanceof DependentColumnFilter) {
            DependentColumnFilter sFilter = (DependentColumnFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = null;
            if (null != sFilter.getComparator()) {
                wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            }
            return new WDependentColumnFilter(sFilter.getFamily(), sFilter.getQualifier(), sFilter.getDropDependentColumn(), op, wComparator);
        }
        if (filter instanceof FamilyFilter) {
            FamilyFilter sFilter = (FamilyFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WFamilyFilter(op, wComparator);
        }
        if (filter instanceof QualifierFilter) {
            QualifierFilter sFilter = (QualifierFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WQualifierFilter(op, wComparator);
        }
        if (filter instanceof RowFilter) {
            RowFilter sFilter = (RowFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WRowFilter(op, wComparator);
        }
        if (filter instanceof ValueFilter) {
            ValueFilter sFilter = (ValueFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WValueFilter(op, wComparator);
        }
        if (filter instanceof FirstKeyValueMatchingQualifiersFilter) {
            throw new IOException("Unsupport filter " + filter.getClass().getName());
        }
        if (filter instanceof FirstKeyOnlyFilter) {
            return new WFirstKeyOnlyFilter();
        }
        if (filter instanceof InclusiveStopFilter) {
            InclusiveStopFilter sFilter = (InclusiveStopFilter)filter;
            return new WInclusiveStopFilter(sFilter.getStopRowKey());
        }
        if (filter instanceof MultipleColumnPrefixFilter) {
            MultipleColumnPrefixFilter sFilter = (MultipleColumnPrefixFilter)filter;
            return new WMultipleColumnPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof PrefixFilter) {
            PrefixFilter sFilter = (PrefixFilter)filter;
            return new WPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof RandomRowFilter) {
            RandomRowFilter sFilter = (RandomRowFilter)filter;
            return new WRandomRowFilter(sFilter.getChance());
        }
        if (filter instanceof SkipFilter) {
            SkipFilter sFilter = (SkipFilter)filter;
            return new WSkipFilter(ElementConvertor.toLindormFilter(sFilter.getFilter()));
        }
        if (filter instanceof TimestampsFilter) {
            TimestampsFilter sFilter = (TimestampsFilter)filter;
            return new WTimestampsFilter(sFilter.getTimestamps());
        }
        if (filter instanceof WhileMatchFilter) {
            WhileMatchFilter sFilter = (WhileMatchFilter)filter;
            return new WWhileMatchFilter(ElementConvertor.toLindormFilter(sFilter.getFilter()));
        }
        if (filter instanceof FuzzyRowFilter) {
            FilterProtos.FuzzyRowFilter proto;
            FuzzyRowFilter fuzzyRowFilter = (FuzzyRowFilter)filter;
            byte[] bytes = fuzzyRowFilter.toByteArray();
            try {
                proto = FilterProtos.FuzzyRowFilter.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e);
            }
            int count = proto.getFuzzyKeysDataCount();
            ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
            for (int i = 0; i < count; ++i) {
                HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
                byte[] keyBytes = current.getFirst().toByteArray();
                byte[] keyMeta = current.getSecond().toByteArray();
                keyMeta = ElementConvertor.maskAdapter(keyMeta);
                fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
            }
            return new WFuzzyRowFilter(fuzzyKeysData);
        }
        if (filter instanceof KeyOnlyFilter) {
            FilterProtos.KeyOnlyFilter proto;
            KeyOnlyFilter keyOnlyFilter = (KeyOnlyFilter)filter;
            byte[] bytes = keyOnlyFilter.toByteArray();
            try {
                proto = FilterProtos.KeyOnlyFilter.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e);
            }
            return new WKeyOnlyFilter(proto.getLenAsVal());
        }
        throw new IOException("Unsupport filter " + filter.getClass().getName());
    }

    private static byte[] maskAdapter(byte[] mask) {
        if (!ElementConvertor.isPreprocessedMask(mask)) {
            return mask;
        }
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1) {
                mask[i] = 0;
                continue;
            }
            if (mask[i] != 2) continue;
            mask[i] = 1;
        }
        return mask;
    }

    private static boolean isPreprocessedMask(byte[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1 || mask[i] == 2) continue;
            return false;
        }
        return true;
    }

    public static WCompareFilter.CompareOp toLindormCompareOp(CompareFilter.CompareOp operator) throws IOException {
        switch (operator) {
            case LESS: {
                return WCompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return WCompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return WCompareFilter.CompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return WCompareFilter.CompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return WCompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return WCompareFilter.CompareOp.GREATER;
            }
            case NO_OP: {
                return WCompareFilter.CompareOp.NO_OP;
            }
        }
        throw new IOException("Unkown operator " + operator);
    }

    private static WBitComparator.BitwiseOp toLindormBitwiseOp(BitComparator.BitwiseOp bitwiseOp) throws IOException {
        switch (bitwiseOp) {
            case AND: {
                return WBitComparator.BitwiseOp.AND;
            }
            case OR: {
                return WBitComparator.BitwiseOp.OR;
            }
            case XOR: {
                return WBitComparator.BitwiseOp.XOR;
            }
        }
        throw new IOException("Unkown BitwiseOp " + bitwiseOp);
    }

    private static WByteArrayComparable toLindormComparator(ByteArrayComparable comparator) throws IOException {
        if (comparator instanceof BinaryComparator) {
            return new WBinaryComparator(comparator.getValue());
        }
        if (comparator instanceof BinaryPrefixComparator) {
            return new WBinaryPrefixComparator(comparator.getValue());
        }
        if (comparator instanceof BitComparator) {
            WBitComparator.BitwiseOp wbitWistOp = ElementConvertor.toLindormBitwiseOp(((BitComparator)comparator).getOperator());
            return new WBitComparator(comparator.getValue(), wbitWistOp);
        }
        if (comparator instanceof NullComparator) {
            return new WNullComparator();
        }
        if (comparator instanceof RegexStringComparator) {
            ComparatorProtos.RegexStringComparator proto;
            try {
                proto = ComparatorProtos.RegexStringComparator.parseFrom((byte[])comparator.toByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e.getMessage());
            }
            return new WRegexStringComparator(proto.getPattern());
        }
        if (comparator instanceof SubstringComparator) {
            return new WSubstringComparator(Bytes.toString((byte[])comparator.getValue()));
        }
        throw new IOException("Unknow comparator " + comparator);
    }

    public static List<Put> toHBasePuts(List<WPut> in) {
        ArrayList<Put> out = new ArrayList<Put>(in.size());
        for (WPut put2 : in) {
            out.add(ElementConvertor.toHBasePut(put2));
        }
        return out;
    }

    public static Put toHBasePut(WPut in) {
        if (in.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        Put out = new Put(in.getRowKey());
        Map<byte[], List<WColumn>> familyMap = in.getFamilyMap();
        for (byte[] family : familyMap.keySet()) {
            for (WColumn col : familyMap.get(family)) {
                out.addColumn(col.getFamily(), col.getQualifier(), col.getTs(), col.getValue());
            }
        }
        return out;
    }

    public static List<WPut> toLindormPuts(List<Put> in) throws IOException {
        ArrayList<WPut> out = new ArrayList<WPut>(in.size());
        for (Put put2 : in) {
            out.add(ElementConvertor.toLindormPut(put2));
        }
        return out;
    }

    public static WPut toLindormPut(Put put2) throws IOException {
        if (put2.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        ElementConvertor.checkPutSupport(put2);
        WPut wput = new WPut(put2.getRow());
        for (List list : put2.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                wput.add(new WColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv), kv.getTimestamp(), ElementConvertor.convertTypeToWType(kv.getTypeByte())));
            }
        }
        return wput;
    }

    public static WIncrement toLindormIncrement(Increment inc) throws IOException {
        if (inc.isEmpty()) {
            throw new IllegalArgumentException("No incremented values found.");
        }
        ElementConvertor.checkIncrementSupport(inc);
        WIncrement winc = new WIncrement(inc.getRow());
        for (List list : inc.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                winc.addColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)));
            }
        }
        return winc;
    }

    public static WAppend toLindormAppend(Append append2) throws IOException {
        if (append2.isEmpty()) {
            throw new IllegalArgumentException("No append values found.");
        }
        ElementConvertor.checkAppendSupport(append2);
        WAppend wAppend = new WAppend(append2.getRow());
        for (List list : append2.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                wAppend.add(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv));
            }
        }
        return wAppend;
    }

    public static WScan toLindormScan(Scan scan) throws IOException {
        TimeRange timeRange;
        ElementConvertor.checkScanSupport(scan);
        WScan wScan = new WScan(scan.getStartRow(), scan.getStopRow());
        wScan.setFamilyMap(scan.getFamilyMap());
        wScan.setCacheBlocks(scan.getCacheBlocks());
        wScan.setCaching(scan.getCaching());
        wScan.setMaxResultSize(scan.getMaxResultSize());
        wScan.setOffset(scan.getRowOffsetPerColumnFamily());
        wScan.setReversed(scan.isReversed());
        if (scan.getMaxVersions() > 1) {
            wScan.setMaxVersions(scan.getMaxVersions());
        }
        if (!(timeRange = scan.getTimeRange()).isAllTime()) {
            wScan.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        wScan.setRaw(scan.isRaw());
        wScan.setIsolationLevel(ElementConvertor.toLindormIsolationLevel(scan.getIsolationLevel()));
        if (scan.getFilter() != null) {
            wScan.setFilter(ElementConvertor.toLindormFilter(scan.getFilter()));
        }
        return wScan;
    }

    private static WScan.IsolationLevel toLindormIsolationLevel(IsolationLevel isolationLevel) throws IOException {
        switch (isolationLevel) {
            case READ_COMMITTED: {
                return WScan.IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return WScan.IsolationLevel.READ_UNCOMMITTED;
            }
        }
        throw new IOException("Unkown isolationLevel " + isolationLevel);
    }

    private static void checkScanSupport(Scan in) throws IOException {
        if (in.getRowOffsetPerColumnFamily() != 0) {
            throw new IOException("Scan#SetRowOffsetPerColumnFamily() is not supported");
        }
    }

    public static List<WGet> toLindormGets(List<Get> in) throws IOException {
        ArrayList<WGet> out = new ArrayList<WGet>(in.size());
        for (Get get2 : in) {
            out.add(ElementConvertor.toLindormGet(get2));
        }
        return out;
    }

    public static Result[] toHBaseResults(List<WResult> in) {
        ArrayList<Result> out = new ArrayList<Result>(in.size());
        for (WResult result : in) {
            out.add(ElementConvertor.toHBaseResult(result));
        }
        return out.toArray(new Result[0]);
    }

    public static Result[] toHBaseResults(WResult[] in) {
        ArrayList<Result> out = new ArrayList<Result>(in.length);
        for (WResult result : in) {
            out.add(ElementConvertor.toHBaseResult(result));
        }
        return out.toArray(new Result[0]);
    }

    public static Result toHBaseResult(WResult in) {
        ArrayList<Cell> cells = new ArrayList<Cell>(in.size());
        for (WColumn columnValue : in.raw()) {
            Cell cell = CellUtil.createCell((byte[])in.getRowKey(), (byte[])columnValue.getFamily(), (byte[])columnValue.getQualifier(), (long)columnValue.getTs(), (byte)ElementConvertor.convertWTypeToHType(columnValue.getType()).getCode(), (byte[])columnValue.getValue());
            cells.add(cell);
        }
        return Result.create(cells);
    }

    public static HColumnDescriptor toHbasecolumnFamilyDescriptor(LindormTableDescriptor tableDescriptor, ColumnFamilyDescriptor in) {
        HColumnDescriptor builder = new HColumnDescriptor(in.getName());
        builder.setMaxVersions(tableDescriptor.getMaxVersions());
        builder.setMinVersions(tableDescriptor.getMinVersions());
        builder.setTimeToLive(tableDescriptor.getTimeToLive());
        builder.setBloomFilterType(BloomType.valueOf((String)in.getBloomFilterType()));
        builder.setCompressionType(Compression.Algorithm.valueOf((String)in.getCompression()));
        if (in.getDataBlockEncoding().equals("INDEX")) {
            builder.setDataBlockEncoding(DataBlockEncoding.DIFF);
        } else {
            builder.setDataBlockEncoding(DataBlockEncoding.valueOf((String)in.getDataBlockEncoding()));
        }
        builder.setMaxVersions(in.getMaxVersions());
        builder.setMinVersions(in.getMinVersions());
        builder.setTimeToLive(in.getTimeToLive());
        return builder;
    }

    public static ColumnFamilyDescriptor toLindormcolumnFamilyDescriptor(HColumnDescriptor in, boolean limitedDescriptorEnable) {
        ColumnFamilyDescriptor out = new ColumnFamilyDescriptor(in.getName());
        if (limitedDescriptorEnable) {
            out.setTimeToLive(in.getTimeToLive(), TimeUnit.SECONDS);
            out.setMaxVersions(in.getMaxVersions());
            out.setMinVersions(in.getMinVersions());
        } else {
            out.setCompression(in.getCompressionType().toString());
            if (in.getDataBlockEncoding() == DataBlockEncoding.DIFF) {
                out.setDataBlockEncoding("INDEX");
            } else {
                out.setDataBlockEncoding(in.getDataBlockEncoding().toString());
            }
            out.setMaxVersions(in.getMaxVersions());
            out.setMinVersions(in.getMinVersions());
            out.setTimeToLive(in.getTimeToLive(), TimeUnit.SECONDS);
        }
        return out;
    }

    public static List<LindormFamilyAttributes> toLindormFamilyAttributes(HColumnDescriptor in, boolean limitedDescriptorEnable) throws IOException {
        ArrayList<LindormAttribute> lindormAttributes = new ArrayList<LindormAttribute>();
        if (limitedDescriptorEnable) {
            if (in.getTimeToLive() > 0) {
                lindormAttributes.add(new LindormAttribute("TTL", Integer.toString(in.getTimeToLive())));
            }
            if (in.getMaxVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("VERSIONS", Integer.toString(in.getMaxVersions())));
            }
            if (in.getMinVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("MIN_VERSIONS", Integer.toString(in.getMinVersions())));
            }
        } else {
            if (in.getCompressionType() != null) {
                lindormAttributes.add(new LindormAttribute("COMPRESSION", in.getCompressionType().toString()));
            }
            if (in.getDataBlockEncoding() != null) {
                lindormAttributes.add(new LindormAttribute("DATA_BLOCK_ENCODING", in.getDataBlockEncoding().toString()));
            }
            if (in.getMaxVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("VERSIONS", Integer.toString(in.getMaxVersions())));
            }
            if (in.getMinVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("MIN_VERSIONS", Integer.toString(in.getMinVersions())));
            }
            if (in.getTimeToLive() > 0) {
                lindormAttributes.add(new LindormAttribute("TTL", Integer.toString(in.getTimeToLive())));
            }
        }
        LindormFamilyAttributes lindormFamilyAttributes = new LindormFamilyAttributes(Bytes.toString((byte[])in.getName()), lindormAttributes);
        return Arrays.asList(lindormFamilyAttributes);
    }

    public static HTableDescriptor toHbaseTableDescriptor(String namespace, LindormTableDescriptor in) {
        HTableDescriptor builder = new HTableDescriptor(TableName.valueOf((String)namespace, (String)in.getName()));
        for (ColumnFamilyDescriptor columnFamilyDescriptor : in.getFamilies()) {
            builder.addFamily(ElementConvertor.toHbasecolumnFamilyDescriptor(in, columnFamilyDescriptor));
        }
        if (in.getTableAttributes() != null) {
            for (Map.Entry entry : in.getTableAttributes().getAttributesMap().entrySet()) {
                builder.setValue((String)entry.getKey(), Bytes.toString((byte[])((byte[])entry.getValue())));
            }
        }
        builder.setValue(TABLEMETAVERSIONBYTES, Bytes.toBytes((int)in.getMetaVersion()));
        return builder;
    }

    public static LindormTableDescriptor toLindormTableDescripter(HTableDescriptor htd, boolean limitedDescriptorEnable) {
        byte[] metaVersion;
        LindormTableDescriptor lindormTableDesc = new LindormTableDescriptor(htd.getTableName().getQualifierAsString());
        for (HColumnDescriptor hbaseFamily : htd.getColumnFamilies()) {
            ColumnFamilyDescriptor column = ElementConvertor.toLindormcolumnFamilyDescriptor(hbaseFamily, limitedDescriptorEnable);
            lindormTableDesc.addFamily(column);
        }
        if (htd.getValues() != null && !limitedDescriptorEnable) {
            for (Map.Entry entry : htd.getValues().entrySet()) {
                if (Bytes.equals((byte[])((ImmutableBytesWritable)entry.getKey()).get(), (byte[])TABLEMETAVERSIONBYTES)) continue;
                lindormTableDesc.setTableAttributes(Bytes.toString((byte[])((ImmutableBytesWritable)entry.getKey()).get()), Bytes.toString((byte[])((ImmutableBytesWritable)entry.getValue()).get()));
            }
        }
        if ((metaVersion = htd.getValue(TABLEMETAVERSIONBYTES)) != null && metaVersion.length != 0) {
            lindormTableDesc.setMetaVersion(Bytes.toInt((byte[])metaVersion));
        }
        lindormTableDesc.setDynamicColumnsEnabled(true);
        return lindormTableDesc;
    }

    public static TableName toHBaseTableName(String table) {
        String[] parts = table.split("[.]");
        if (parts.length == 1) {
            return TableName.valueOf((String)table);
        }
        return TableName.valueOf((String)parts[0], (String)parts[1]);
    }

    public static WRowMutations toLindormRowMutation(RowMutations rowMutations) throws IOException {
        WRowMutations wRowMutations = new WRowMutations(rowMutations.getRow());
        for (Mutation mutation : rowMutations.getMutations()) {
            if (mutation instanceof Put) {
                WPut wPut = ElementConvertor.toLindormPut((Put)mutation);
                wRowMutations.add(wPut);
                continue;
            }
            if (mutation instanceof Delete) {
                WDelete wDelete = ElementConvertor.toLindormDelete((Delete)mutation);
                wRowMutations.add(wDelete);
                continue;
            }
            throw new IOException("Only Put or Delete is supported in RowMutation: " + mutation);
        }
        return wRowMutations;
    }

    public static DataType toInterpreterDataType(String interpreterClassName) {
        DataType dataType = INTERPRETER_DATATYPE_MAP.get(interpreterClassName);
        if (dataType == null) {
            throw new UnsupportedOperationException("Unsupported interpreterClass " + interpreterClassName);
        }
        return dataType;
    }

    public static byte[] toValueBytes(ColumnValue cv, ColumnInterpreter interpreterClassName) {
        BigDecimal bigDecimal = cv.getDecimal();
        if (interpreterClassName instanceof LongColumnInterpreter) {
            return Bytes.toBytes((long)bigDecimal.longValue());
        }
        if (interpreterClassName instanceof DoubleColumnInterpreter) {
            return Bytes.toBytes((double)bigDecimal.doubleValue());
        }
        if (interpreterClassName instanceof BigDecimalColumnInterpreter) {
            return Bytes.toBytes((BigDecimal)bigDecimal);
        }
        throw new UnsupportedOperationException("Unsupported interpreterClass " + interpreterClassName.getClass());
    }

    public static String toLindormTableFullName(TableName tableName) {
        return tableName.getNamespaceAsString() + "." + tableName.getQualifierAsString();
    }

    static {
        INTERPRETER_DATATYPE_MAP.put(LongColumnInterpreter.class.getName(), DataType.LONG);
        INTERPRETER_DATATYPE_MAP.put(DoubleColumnInterpreter.class.getName(), DataType.DOUBLE);
        INTERPRETER_DATATYPE_MAP.put(BigDecimalColumnInterpreter.class.getName(), DataType.DECIMAL);
        TABLEMETAVERSIONBYTES = Bytes.toBytes((String)TABLEMETAVERSION);
    }
}

