/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseThriftConnection;
import com.alibaba.hbase.client.ThriftClientBuilder;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class AliHBaseThriftClientBuilder
extends ThriftClientBuilder {
    public static final String ACCESSKEYHEADER = "ACCESSKEYID";
    public static final String ACCESSTIMESTAMPHEADER = "ACCESSTIMESTAMP";
    public static final String ACCESSSIGNATUREHEADER = "ACCESSSIGNATURE";
    public static final String INSTANCEIDHEADER = "INSTANCEID";
    public static final String INSTANCEHOST = "INSTANCEHOST";
    public static final String ACCESSUUID = "ACCESSUUID";
    public static final String TIMEOUTHEADER = "TIMEOUT";
    Map<String, String> customHeader = new HashMap<String, String>();

    public AliHBaseThriftClientBuilder(AliHBaseThriftConnection connection) {
        super(connection);
    }

    public void addCostumHeader(String key, String value) {
        this.customHeader.put(key, value);
    }

    @Override
    public Pair<THBaseService.Client, TTransport> getClient() throws IOException {
        String url = this.connection.getHost();
        try {
            AliHBaseClient httpClient = new AliHBaseClient(url, this.connection.getHttpClient(), this.connection.getConfiguration());
            for (Map.Entry<String, String> header : this.customHeader.entrySet()) {
                httpClient.setCustomHeader(header.getKey(), header.getValue());
            }
            httpClient.open();
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
            return new Pair((Object)client, (Object)httpClient);
        }
        catch (NoSuchAlgorithmException | TTransportException e) {
            throw new IOException(e);
        }
    }

    public static byte[] toSHA1(byte[] key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return md.digest(key);
    }

    public static byte[] toReversed(String key) {
        return Bytes.toBytes((String)new StringBuilder(key).reverse().toString());
    }

    public static byte[] xor(byte[] left, byte[] right) {
        int i;
        byte[] shortbytes;
        byte[] longbytes;
        if (left.length >= right.length) {
            longbytes = left;
            shortbytes = right;
        } else {
            longbytes = right;
            shortbytes = left;
        }
        byte[] xorBytes = new byte[longbytes.length];
        for (i = 0; i < shortbytes.length; ++i) {
            xorBytes[i] = (byte)(shortbytes[i] ^ longbytes[i]);
        }
        while (i < longbytes.length) {
            xorBytes[i] = longbytes[i];
            ++i;
        }
        return xorBytes;
    }

    public static String hmacSHA1Signature(String accessKeyID, byte[] hashedPassword, byte[] encodedNameAndPass, long timestamp, String UUID2) throws IOException {
        try {
            byte[] token = AliHBaseThriftClientBuilder.xor(AliHBaseThriftClientBuilder.toSHA1(Bytes.add((byte[])Bytes.toBytes((long)timestamp), (byte[])Bytes.toBytes((String)UUID2), (byte[])encodedNameAndPass)), hashedPassword);
            return Bytes.toStringBinary((byte[])token);
        }
        catch (Throwable t) {
            throw new IOException("Failed creating signature for '" + accessKeyID + "'", t);
        }
    }

    public class AliHBaseClient
    extends TTransport {
        private URL url_ = null;
        private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
        private InputStream inputStream_ = null;
        private int connectTimeout_ = 0;
        private int readTimeout_ = 0;
        private Map<String, String> customHeaders_ = null;
        private final HttpHost host;
        private final HttpClient client;
        private HttpClientContext httpContext;
        private CookieStore cookieStore;
        private Configuration conf;
        private final String userName;
        private final String instanceID;
        private final String UUID = java.util.UUID.randomUUID().toString();
        private final byte[] hashedPassword;
        private final byte[] encodedNameAndPass;
        private int operationTimeout;

        public AliHBaseClient(String url, HttpClient client, Configuration conf) throws TTransportException, NoSuchAlgorithmException {
            try {
                this.url_ = new URL(url);
                this.client = client;
                this.httpContext = HttpClientContext.create();
                this.cookieStore = new BasicCookieStore();
                this.httpContext.setCookieStore(this.cookieStore);
                this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
                this.conf = conf;
                this.userName = conf.get("hbase.client.username");
                if (this.userName == null) {
                    throw new RuntimeException("hbase.client.username is not set");
                }
                String password = conf.get("hbase.client.password");
                if (password == null) {
                    throw new RuntimeException("hbase.client.password is not set");
                }
                this.hashedPassword = AliHBaseThriftClientBuilder.toSHA1(Bytes.toBytes((String)password));
                this.encodedNameAndPass = AliHBaseThriftClientBuilder.toSHA1(Bytes.add((byte[])this.hashedPassword, (byte[])AliHBaseThriftClientBuilder.toReversed(this.userName)));
                this.instanceID = conf.get("hbase.client.instanceid");
                if (this.instanceID == null) {
                    throw new RuntimeException("hbase.client.instanceid is not set");
                }
                this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
            }
            catch (IOException iox) {
                throw new TTransportException((Throwable)iox);
            }
        }

        public void setConnectTimeout(int timeout) {
            this.connectTimeout_ = timeout;
            if (null != this.client) {
                this.client.getParams().setParameter("http.connection.timeout", (Object)this.connectTimeout_);
            }
        }

        public void setReadTimeout(int timeout) {
            this.readTimeout_ = timeout;
            if (null != this.client) {
                this.client.getParams().setParameter("http.socket.timeout", (Object)this.readTimeout_);
            }
        }

        public void setCustomHeaders(Map<String, String> headers) {
            this.customHeaders_ = headers;
        }

        public void setCustomHeader(String key, String value) {
            if (this.customHeaders_ == null) {
                this.customHeaders_ = new HashMap<String, String>();
            }
            this.customHeaders_.put(key, value);
        }

        public void open() {
        }

        public void close() {
            if (null != this.inputStream_) {
                try {
                    this.inputStream_.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.inputStream_ = null;
            }
        }

        public boolean isOpen() {
            return true;
        }

        public int read(byte[] buf, int off, int len) throws TTransportException {
            if (this.inputStream_ == null) {
                throw new TTransportException("Response buffer is empty, no request.");
            }
            try {
                int ret = this.inputStream_.read(buf, off, len);
                if (ret == -1) {
                    throw new TTransportException("No more data available.");
                }
                return ret;
            }
            catch (IOException iox) {
                throw new TTransportException((Throwable)iox);
            }
        }

        public void write(byte[] buf, int off, int len) {
            this.requestBuffer_.write(buf, off, len);
        }

        private void consume(HttpEntity entity) throws IOException {
            InputStream instream;
            if (entity == null) {
                return;
            }
            if (entity.isStreaming() && (instream = entity.getContent()) != null) {
                instream.close();
            }
        }

        private void addAKAuthHeader(HttpPost post) throws IOException {
            long timestamp = System.currentTimeMillis();
            String signature = AliHBaseThriftClientBuilder.hmacSHA1Signature(this.userName, this.hashedPassword, this.encodedNameAndPass, timestamp, this.UUID);
            post.addHeader(AliHBaseThriftClientBuilder.ACCESSKEYHEADER, this.userName);
            post.addHeader(AliHBaseThriftClientBuilder.ACCESSTIMESTAMPHEADER, Long.toString(timestamp));
            post.addHeader(AliHBaseThriftClientBuilder.ACCESSSIGNATUREHEADER, signature);
            post.addHeader(AliHBaseThriftClientBuilder.INSTANCEIDHEADER, this.instanceID);
            post.addHeader(AliHBaseThriftClientBuilder.INSTANCEHOST, this.url_.getHost());
            post.addHeader(AliHBaseThriftClientBuilder.ACCESSUUID, this.UUID);
        }

        private void flushUsingHttpClient() throws TTransportException {
            if (null == this.client) {
                throw new TTransportException("Null HttpClient, aborting.");
            }
            byte[] data = this.requestBuffer_.toByteArray();
            this.requestBuffer_.reset();
            HttpPost post = null;
            InputStream is = null;
            try {
                post = new HttpPost(this.url_.getFile());
                post.setHeader("Content-Type", "application/x-thrift");
                post.setHeader("Accept", "application/x-thrift");
                post.setHeader("User-Agent", "Java/THttpClient/HC");
                if (null != this.customHeaders_) {
                    for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                        post.setHeader(header.getKey(), header.getValue());
                    }
                }
                this.addAKAuthHeader(post);
                post.setHeader(AliHBaseThriftClientBuilder.TIMEOUTHEADER, String.valueOf(this.operationTimeout));
                post.setEntity((HttpEntity)new ByteArrayEntity(data));
                HttpResponse response = this.client.execute(this.host, (HttpRequest)post, (HttpContext)this.httpContext);
                int responseCode = response.getStatusLine().getStatusCode();
                is = response.getEntity().getContent();
                byte[] buf = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int len = 0;
                do {
                    if ((len = is.read(buf)) <= 0) continue;
                    baos.write(buf, 0, len);
                } while (-1 != len);
                try {
                    this.consume(response.getEntity());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (responseCode != 200) {
                    String error = Bytes.toString((byte[])baos.toByteArray());
                    throw new TTransportException(error);
                }
                this.inputStream_ = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (IOException ioe) {
                if (null != post) {
                    post.abort();
                }
                throw new TTransportException((Throwable)ioe);
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        throw new TTransportException((Throwable)ioe);
                    }
                }
            }
        }

        public void flush() throws TTransportException {
            this.flushUsingHttpClient();
        }
    }
}

