/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.mongodb;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import java.util.ArrayList;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;

public class GeoJsonPolygonReader
implements ObjectReader<GeoJsonPolygon> {
    public static final GeoJsonPolygonReader INSTANCE = new GeoJsonPolygonReader();
    static final long HASH_TYPE = Fnv.hashCode64((String)"type");
    static final long HASH_POLYGON = Fnv.hashCode64((String)"Polygon");
    static final long HASH_COORDINATES = Fnv.hashCode64((String)"coordinates");

    public GeoJsonPolygon readObject(JSONReader jsonReader, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        jsonReader.nextIfObjectStart();
        ArrayList points = new ArrayList();
        while (!jsonReader.nextIfObjectEnd()) {
            long nameHashCode = jsonReader.readFieldNameHashCode();
            if (nameHashCode == HASH_TYPE) {
                long valueHashCode = jsonReader.readValueHashCode();
                if (valueHashCode == HASH_POLYGON) continue;
                throw new JSONException("not support input type : " + jsonReader.getString());
            }
            if (nameHashCode == HASH_COORDINATES) {
                GeoJsonLineString lineString = (GeoJsonLineString)jsonReader.read(GeoJsonLineString.class);
                points.addAll(lineString.getCoordinates());
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.nextIfMatch(',');
        return new GeoJsonPolygon(points);
    }
}

