/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;

public class JSONArray
extends com.alibaba.fastjson.JSON
implements List {
    private List list = new com.alibaba.fastjson2.JSONArray();

    public JSONArray() {
    }

    public JSONArray(List list) {
        this.list = list;
    }

    public JSONObject getJSONObject(int index) {
        Object value = this.list.get(index);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value);
        }
        if (value instanceof String) {
            return com.alibaba.fastjson.JSON.parseObject((String)value);
        }
        throw new JSONException("TODO");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object item) {
        return this.list.add(item);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object set(int index, Object element) {
        return this.list.set(index, element);
    }

    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String getString(int index) {
        Object value = this.list.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return JSON.toJSONString(value);
    }

    public JSONArray getJSONArray(int index) {
        Object value = this.list.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof List) {
            return new JSONArray((List)value);
        }
        return (JSONArray)JSONArray.toJSON(value);
    }

    public <T> T getObject(int index, Class<T> clazz) {
        Object obj = this.list.get(index);
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (T)obj;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(obj.getClass(), clazz);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        String json = com.alibaba.fastjson.JSON.toJSONString(obj);
        ObjectReader objectReader = provider.getObjectReader(clazz);
        JSONReader jsonReader = JSONReader.of((String)json);
        String defaultDateFormat = com.alibaba.fastjson.JSON.DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            jsonReader.getContext().setUtilDateFormat(defaultDateFormat);
        }
        return (T)objectReader.readObject(jsonReader);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(clazz);
        for (Object item : this) {
            if (!(item instanceof Map)) {
                throw new JSONException("TODO");
            }
            Object classItem = objectReader.createInstance((Map)item);
            list.add(classItem);
        }
        return list;
    }

    public JSONArray fluentAdd(Object e) {
        this.list.add(e);
        return this;
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return (T)JSON.toJavaObject((Object)this, clazz);
    }

    public String toString() {
        return JSONArray.toJSONString(this);
    }
}

