/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.ribbon;

import com.alibaba.edas.ribbon.MigrationProperties;
import com.alibaba.edas.ribbon.MigrationServer;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
public class MigrationServerList
implements ServerList<MigrationServer> {
    private MigrationProperties migrationProperties;
    private DiscoveryClient discoveryClient;
    private IClientConfig config;

    public MigrationServerList(MigrationProperties migrationProperties, IClientConfig config, DiscoveryClient discoveryClient) {
        this.migrationProperties = migrationProperties;
        this.config = config;
        this.discoveryClient = discoveryClient;
    }

    public List<MigrationServer> getInitialListOfServers() {
        return this.getServers();
    }

    public List<MigrationServer> getUpdatedListOfServers() {
        return this.getServers();
    }

    public List<MigrationServer> getServers() {
        LinkedList<MigrationServer> servers = new LinkedList<MigrationServer>();
        for (DiscoveryClient discoveryClient : ((CompositeDiscoveryClient)this.discoveryClient).getDiscoveryClients()) {
            List instances = discoveryClient.getInstances(this.config.getClientName());
            String description = discoveryClient.description();
            if (this.shouldExclude(description)) continue;
            for (ServiceInstance instance : instances) {
                MigrationServer server = new MigrationServer(instance.getHost(), instance.getPort(), description, instance.getMetadata());
                servers.add(server);
            }
        }
        return servers;
    }

    private boolean shouldExclude(String description) {
        if (null == this.migrationProperties.getSubscribes() || this.migrationProperties.getSubscribes().isEmpty()) {
            return false;
        }
        for (String str : this.migrationProperties.getSubscribes()) {
            if (!description.toUpperCase().contains(str.toUpperCase())) continue;
            return false;
        }
        return true;
    }
}

