/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLConstraintImpl;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLUnique
extends SQLConstraintImpl
implements SQLUniqueConstraint,
SQLTableElement {
    protected final List<SQLSelectOrderByItem> columns = new ArrayList<SQLSelectOrderByItem>();

    @Override
    public List<SQLSelectOrderByItem> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLExpr column) {
        if (column == null) {
            return;
        }
        this.addColumn(new SQLSelectOrderByItem(column));
    }

    public void addColumn(SQLSelectOrderByItem column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.getName());
            this.acceptChild(visitor, this.getColumns());
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean containsColumn(String column) {
        for (SQLSelectOrderByItem item : this.columns) {
            SQLExpr expr = item.getExpr();
            if (!(expr instanceof SQLIdentifierExpr) || !SQLUtils.nameEquals(((SQLIdentifierExpr)expr).getName(), column)) continue;
            return true;
        }
        return false;
    }

    public void cloneTo(SQLUnique x) {
        super.cloneTo(x);
        for (SQLSelectOrderByItem column : this.columns) {
            SQLSelectOrderByItem column2 = column.clone();
            column2.setParent(x);
            x.columns.add(column2);
        }
    }

    @Override
    public SQLUnique clone() {
        SQLUnique x = new SQLUnique();
        this.cloneTo(x);
        return x;
    }

    @Override
    public void simplify() {
        super.simplify();
        for (SQLSelectOrderByItem item : this.columns) {
            SQLIdentifierExpr identExpr;
            String columnName;
            String normalized;
            SQLExpr column = item.getExpr();
            if (!(column instanceof SQLIdentifierExpr) || (normalized = SQLUtils.normalize(columnName = (identExpr = (SQLIdentifierExpr)column).getName(), this.dbType)) == columnName) continue;
            item.setExpr(new SQLIdentifierExpr(columnName));
        }
    }

    public boolean applyColumnRename(SQLName columnName, SQLName to) {
        for (SQLSelectOrderByItem orderByItem : this.columns) {
            SQLExpr expr = orderByItem.getExpr();
            if (!(expr instanceof SQLName) || !SQLUtils.nameEquals((SQLName)expr, columnName)) continue;
            orderByItem.setExpr(to.clone());
            return true;
        }
        return false;
    }

    public boolean applyDropColumn(SQLName columnName) {
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            SQLExpr expr = this.columns.get(i).getExpr();
            if (expr instanceof SQLName && SQLUtils.nameEquals((SQLName)expr, columnName)) {
                this.columns.remove(i);
                return true;
            }
            if (!(expr instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)expr).getMethodName(), columnName.getSimpleName())) continue;
            this.columns.remove(i);
            return true;
        }
        return false;
    }
}

