/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.tools.codeinterpretertool.ToolCallCodeInterpreter;
import com.alibaba.dashscope.tools.search.ToolCallQuarkSearch;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiModalMessageAdapter
extends TypeAdapter<MultiModalMessage> {
    private void writeMapObject(JsonWriter out, Map<String, Object> mapObject) throws IOException {
        if (mapObject != null) {
            out.beginObject();
            for (Map.Entry<String, Object> entry : mapObject.entrySet()) {
                out.name(entry.getKey());
                this.writeValue(out, entry.getValue());
            }
            out.endObject();
        }
    }

    private void writeValue(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof String) {
            out.value((String)value);
        } else if (value instanceof Integer) {
            out.value((Number)((Integer)value));
        } else if (value instanceof Long) {
            out.value((Number)((Long)value));
        } else if (value instanceof Double) {
            out.value((Number)((Double)value));
        } else if (value instanceof Float) {
            out.value((Number)((Float)value));
        } else if (value instanceof Boolean) {
            out.value((Boolean)value);
        } else if (value instanceof Character) {
            out.value((long)((Character)value).charValue());
        } else if (value instanceof List) {
            out.beginArray();
            List list = (List)value;
            for (Object item : list) {
                this.writeValue(out, item);
            }
            out.endArray();
        } else if (value instanceof Map) {
            this.writeMapObject(out, (Map)value);
        } else {
            out.value(value.toString());
        }
    }

    private void writeToolCallBase(JsonWriter writer, ToolCallBase toolCallBase) throws IOException {
        writer.beginObject();
        writer.name("id").value(toolCallBase.getId());
        writer.name("type").value(toolCallBase.getType());
        if (toolCallBase.getIndex() != null) {
            writer.name("index").value((Number)toolCallBase.getIndex());
        }
        if (toolCallBase instanceof ToolCallFunction) {
            ToolCallFunction functionCall = (ToolCallFunction)toolCallBase;
            ToolCallFunction.CallFunction callFunction = functionCall.getFunction();
            writer.name("function").beginObject();
            if (callFunction != null) {
                writer.name("name").value(callFunction.getName());
                writer.name("arguments").value(callFunction.getArguments());
                writer.name("output").value(callFunction.getOutput());
            }
            writer.endObject();
        } else if (toolCallBase instanceof ToolCallQuarkSearch) {
            ToolCallQuarkSearch quarkSearchCall = (ToolCallQuarkSearch)toolCallBase;
            writer.name("quark_search").beginObject();
            if (quarkSearchCall.getQuarkSearch() != null) {
                for (Map.Entry<String, String> entry : quarkSearchCall.getQuarkSearch().entrySet()) {
                    writer.name(entry.getKey()).value(entry.getValue());
                }
            }
            writer.endObject();
        } else if (toolCallBase instanceof ToolCallCodeInterpreter) {
            // empty if block
        }
        writer.endObject();
    }

    private ToolCallFunction convertToCallFunction(LinkedTreeMap<String, Object> toolCall) {
        Object indexObj;
        ToolCallFunction functionCall = new ToolCallFunction();
        if (toolCall.containsKey((Object)"function")) {
            ToolCallFunction.CallFunction callFunction = functionCall.new ToolCallFunction.CallFunction();
            LinkedTreeMap fc = (LinkedTreeMap)toolCall.get((Object)"function");
            if (fc.containsKey((Object)"name")) {
                callFunction.setName(fc.get((Object)"name").toString());
            }
            if (fc.containsKey((Object)"arguments")) {
                callFunction.setArguments(fc.get((Object)"arguments").toString());
            }
            if (fc.containsKey((Object)"output")) {
                callFunction.setOutput(fc.get((Object)"output").toString());
            }
            functionCall.setFunction(callFunction);
        }
        functionCall.setType(toolCall.get((Object)"type").toString());
        if (toolCall.containsKey((Object)"id")) {
            functionCall.setId(toolCall.get((Object)"id").toString());
        }
        if (toolCall.containsKey((Object)"index") && (indexObj = toolCall.get((Object)"index")) instanceof Number) {
            functionCall.setIndex(((Number)indexObj).intValue());
        }
        return functionCall;
    }

    public void write(JsonWriter out, MultiModalMessage value) throws IOException {
        out.beginObject();
        out.name("role");
        out.value(value.getRole());
        out.name("content");
        out.beginArray();
        for (Map<String, Object> item : value.getContent()) {
            this.writeMapObject(out, item);
        }
        out.endArray();
        if (value.getAnnotations() != null) {
            out.name("annotations");
            out.beginArray();
            for (Map<String, Object> item : value.getAnnotations()) {
                this.writeMapObject(out, item);
            }
            out.endArray();
        }
        if (value.getReasoningContent() != null) {
            out.name("reasoning_content");
            out.value(value.getReasoningContent());
        }
        if (value.getToolCalls() != null) {
            out.name("tool_calls");
            out.beginArray();
            List<ToolCallBase> toolCalls = value.getToolCalls();
            for (ToolCallBase tc : JsonUtils.fromJson(JsonUtils.toJson(toolCalls), ToolCallBase[].class)) {
                this.writeToolCallBase(out, tc);
            }
            out.endArray();
        }
        if (value.getToolCallId() != null) {
            out.name("tool_call_id");
            out.value(value.getToolCallId());
        }
        if (value.getName() != null) {
            out.name("name");
            out.value(value.getName());
        }
        out.endObject();
    }

    public MultiModalMessage read(JsonReader in) throws IOException {
        Map objectMap = (Map)JsonUtils.gson.fromJson(in, Map.class);
        MultiModalMessage msg = new MultiModalMessage();
        if (objectMap.containsKey("role")) {
            msg.setRole((String)objectMap.get("role"));
            objectMap.remove("role");
        }
        if (objectMap.containsKey("content")) {
            Object content = objectMap.get("content");
            if (content instanceof String) {
                msg.setContent(Arrays.asList(Collections.singletonMap("text", (String)content)));
            } else {
                msg.setContent((List)content);
            }
            objectMap.remove("content");
        }
        if (objectMap.containsKey("annotations")) {
            msg.setAnnotations((List)objectMap.get("annotations"));
            objectMap.remove("annotations");
        }
        if (objectMap.containsKey("reasoning_content")) {
            String reasoningContent = (String)objectMap.get("reasoning_content");
            msg.setReasoningContent(reasoningContent);
            objectMap.remove("reasoning_content");
        }
        if (objectMap.containsKey("tool_calls")) {
            Object toolCallsObj = objectMap.get("tool_calls");
            if (toolCallsObj instanceof List) {
                String type;
                LinkedTreeMap firstToolCall;
                List toolCallsList = (List)toolCallsObj;
                boolean needConversion = false;
                if (!toolCallsList.isEmpty() && toolCallsList.get(0) instanceof LinkedTreeMap && (firstToolCall = (LinkedTreeMap)toolCallsList.get(0)).containsKey((Object)"type") && (type = firstToolCall.get((Object)"type").toString()).equals("function")) {
                    needConversion = true;
                }
                if (needConversion) {
                    msg.toolCalls = new ArrayList<ToolCallBase>();
                    List toolCalls = (List)toolCallsObj;
                    for (LinkedTreeMap toolCall : toolCalls) {
                        msg.toolCalls.add(this.convertToCallFunction((LinkedTreeMap<String, Object>)toolCall));
                    }
                } else {
                    msg.setToolCalls((List)toolCallsObj);
                }
            }
            objectMap.remove("tool_calls");
        }
        if (objectMap.containsKey("tool_call_id")) {
            String toolCallId = (String)objectMap.get("tool_call_id");
            msg.setToolCallId(toolCallId);
            objectMap.remove("tool_call_id");
        }
        if (objectMap.containsKey("name")) {
            String name = (String)objectMap.get("name");
            msg.setName(name);
            objectMap.remove("name");
        }
        return msg;
    }
}

