/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationParamBase;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.SearchOptions;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.reactivex.Flowable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Semaphore;

public class GenerationStreamCall {
    public static void streamCall() throws NoApiKeyException, ApiException, InputRequiredException {
        GenerationParamBase param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().model("qwen-turbo")).prompt("\u4f60\u597d")).temperature(Float.valueOf(1.0f))).incrementalOutput(false)).repetitionPenalty(Float.valueOf(1.0f))).topK(50)).build();
        System.out.println(param.getHttpBody().toString());
        Generation generation = new Generation();
        Flowable<GenerationResult> flowable = generation.streamCall(param);
        flowable.blockingForEach(message -> {
            System.out.println(JsonUtils.toJson(message));
            Long time = System.currentTimeMillis();
        });
    }

    public static void streamCallWithCallback() throws NoApiKeyException, ApiException, InputRequiredException, InterruptedException {
        Generation gen = new Generation();
        GenerationParamBase param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().model("qwen-plus")).prompt("\u4f60\u597d")).topP(0.8)).incrementalOutput(false)).build();
        final Semaphore semaphore = new Semaphore(0);
        gen.streamCall(param, new ResultCallback<GenerationResult>(){

            @Override
            public void onEvent(GenerationResult message) {
                System.out.println(message);
            }

            @Override
            public void onError(Exception err) {
                System.out.println(String.format("Exception: %s", err.getMessage()));
                semaphore.release();
            }

            @Override
            public void onComplete() {
                System.out.println("Completed");
                semaphore.release();
            }
        });
        semaphore.acquire();
    }

    public static void streamCallWithReasoningContent() throws NoApiKeyException, ApiException, InputRequiredException {
        Generation gen = new Generation();
        GenerationParamBase param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().model("qwen-plus")).prompt("1.1\u548c0.9\u54ea\u4e2a\u5927")).topP(0.8)).incrementalOutput(false)).enableThinking(true)).resultFormat("message")).build();
        Flowable<GenerationResult> result = gen.streamCall(param);
        result.blockingForEach(message -> System.out.println(JsonUtils.toJson(message)));
    }

    public static void streamCallWithSearchOptions() throws NoApiKeyException, ApiException, InputRequiredException {
        Generation gen = new Generation();
        GenerationParamBase param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().model("qwen-plus")).prompt("\u8054\u7f51\u641c\u7d22\u660e\u5929\u676d\u5dde\u5929\u6c14\u5982\u4f55\uff1f")).enableSearch(true)).resultFormat("message")).incrementalOutput(true)).searchOptions((SearchOptions)((SearchOptions.SearchOptionsBuilder)((SearchOptions.SearchOptionsBuilder)((SearchOptions.SearchOptionsBuilder)((SearchOptions.SearchOptionsBuilder)((SearchOptions.SearchOptionsBuilder)((SearchOptions.SearchOptionsBuilder)SearchOptions.builder().enableSource(true)).enableCitation(true)).citationFormat("[ref_<number>]")).searchStrategy("pro_max")).forcedSearch(true)).prependSearchResult(true)).build())).build();
        Flowable<GenerationResult> result = gen.streamCall(param);
        result.blockingForEach(message -> System.out.println(JsonUtils.toJson(message)));
    }

    public static void streamCallWithToolCalls() throws NoApiKeyException, ApiException, InputRequiredException {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchemaWeather = generator.generateSchema(GetWeatherTool.class, new Type[0]);
        ObjectNode jsonSchemaTime = generator.generateSchema(GetTimeTool.class, new Type[0]);
        Object fdWeather = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_weather")).description("\u83b7\u53d6\u6307\u5b9a\u5730\u533a\u7684\u5929\u6c14")).parameters(JsonUtils.parseString(jsonSchemaWeather.toString()).getAsJsonObject())).build();
        Object fdTime = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_time")).description("\u83b7\u53d6\u5f53\u524d\u65f6\u523b\u7684\u65f6\u95f4")).parameters(JsonUtils.parseString(jsonSchemaTime.toString()).getAsJsonObject())).build();
        Object systemMsg = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role(Role.SYSTEM.getValue())).content("You are a helpful assistant. When asked a question, use tools wherever possible.")).build();
        Object userMsg = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role(Role.USER.getValue())).content("\u676d\u5dde\u5929\u6c14")).build();
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(Arrays.asList(systemMsg, userMsg));
        GenerationParamBase param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(System.getenv("DASHSCOPE_API_KEY"))).model("qwen-plus")).messages(messages)).resultFormat(ConversationParam.ResultFormat.MESSAGE)).incrementalOutput(false)).tools(Arrays.asList(((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)fdWeather)).build(), ((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)fdTime)).build()))).build();
        Generation gen = new Generation();
        Flowable<GenerationResult> result = gen.streamCall(param);
        result.blockingForEach(message -> System.out.println(JsonUtils.toJson(message)));
    }

    public static void main(String[] args) {
        try {
            GenerationStreamCall.streamCall();
        }
        catch (ApiException | InputRequiredException | NoApiKeyException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

    public static class GetTimeTool {
        public String call() {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String currentTime = "\u5f53\u524d\u65f6\u95f4\uff1a" + now.format(formatter) + "\u3002";
            return currentTime;
        }
    }

    public static class GetWeatherTool {
        private String location;

        public GetWeatherTool(String location) {
            this.location = location;
        }

        public String call() {
            return this.location + "\u4eca\u5929\u662f\u6674\u5929";
        }
    }
}

