/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol.okhttp;

import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.ConnectionConfigurations;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.utils.Constants;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientFactory.class);

    private OkHttpClientFactory() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException();
        }
    }

    public static OkHttpClient getOkHttpClient() {
        return Holder.INSTANCE;
    }

    public static OkHttpClient getNewOkHttpClient(ConnectionOptions connectionOptions) {
        OkHttpClient.Builder builder = Holder.INSTANCE.newBuilder();
        builder.connectTimeout(connectionOptions.getConnectTimeout()).readTimeout(connectionOptions.getReadTimeout()).writeTimeout(connectionOptions.getWriteTimeout()).connectionPool(new ConnectionPool(1, 2L, TimeUnit.MINUTES));
        if (connectionOptions.getProxy() != null) {
            builder.proxy(connectionOptions.getProxy());
        }
        if (connectionOptions.getProxyAuthenticator() != null) {
            builder.proxyAuthenticator(connectionOptions.getProxyAuthenticator());
        }
        return builder.build();
    }

    private static class Holder {
        private static final OkHttpClient INSTANCE = Holder.createInstance();

        private Holder() {
        }

        private static OkHttpClient createInstance() {
            ConnectionConfigurations connectionConfigurations = Constants.connectionConfigurations;
            if (connectionConfigurations == null) {
                connectionConfigurations = ConnectionConfigurations.builder().build();
            }
            Object defaultOptions = ClientOptions.builder().build();
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.valueOf((String)((ClientOptions)defaultOptions).getNetworkLoggingLevel()));
            int connectionPoolSize = connectionConfigurations.getConnectionPoolSize();
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(connectionConfigurations.getMaximumAsyncRequests().intValue());
            dispatcher.setMaxRequestsPerHost(connectionConfigurations.getMaximumAsyncRequestsPerHost().intValue());
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.connectTimeout(connectionConfigurations.getConnectTimeout()).readTimeout(connectionConfigurations.getReadTimeout()).writeTimeout(connectionConfigurations.getWriteTimeout()).addInterceptor((Interceptor)logging).dispatcher(dispatcher).protocols(Collections.singletonList(Protocol.HTTP_1_1)).connectionPool(new ConnectionPool(connectionPoolSize, connectionConfigurations.getConnectionIdleTimeout().getSeconds(), TimeUnit.SECONDS));
            if (connectionConfigurations.getProxy() != null) {
                clientBuilder.proxy(connectionConfigurations.getProxy());
            }
            if (connectionConfigurations.getProxyAuthenticator() != null) {
                clientBuilder.proxyAuthenticator(connectionConfigurations.getProxyAuthenticator());
            }
            return clientBuilder.build();
        }
    }
}

