/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.conversation;

import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.conversation.ConversationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.Flowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conversation {
    private static final Logger log = LoggerFactory.getLogger(Conversation.class);
    private final SynchronizeHalfDuplexApi<ConversationParam> syncApi;
    private final ApiServiceOption serviceOption = this.defaultApiServiceOption();

    public ApiServiceOption defaultApiServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.TEXT_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
    }

    public Conversation() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Conversation(String protocol) {
        this.serviceOption.setProtocol(Protocol.of(protocol));
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public Conversation(String protocol, String baseUrl) {
        if (Protocol.HTTP.getValue().equals(protocol)) {
            this.serviceOption.setBaseHttpUrl(baseUrl);
        } else {
            this.serviceOption.setBaseWebSocketUrl(baseUrl);
        }
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public ConversationResult call(ConversationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        return ConversationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(ConversationParam param, final ResultCallback<ConversationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(ConversationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<ConversationResult> streamCall(ConversationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.syncApi.streamCall(param).map(item -> ConversationResult.fromDashScopeResult(item));
    }

    public void streamCall(ConversationParam param, final ResultCallback<ConversationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                callback.onEvent(ConversationResult.fromDashScopeResult(msg));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Models {
        @Deprecated
        public static final String QWEN_V1 = "qwen-v1";
        public static final String QWEN_TURBO = "qwen-turbo";
        @Deprecated
        public static final String QWEN_PLUG_V1 = "qwen-plus-v1";
        public static final String QWEN_PLUS = "qwen-plus";
        public static final String QWEN_MAX = "qwen-max";
    }
}

