/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import com.alibaba.cloud.seata.feign.SeataFeignBlockingLoadBalancerClient;
import com.alibaba.cloud.seata.feign.SeataFeignClient;
import com.alibaba.cloud.seata.feign.SeataLoadBalancerFeignClient;
import feign.Client;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

public class SeataFeignObjectWrapper {
    private static final Log LOG = LogFactory.getLog(SeataFeignObjectWrapper.class);
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private SpringClientFactory springClientFactory;

    SeataFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof SeataFeignClient)) {
            if (bean instanceof LoadBalancerFeignClient) {
                LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
                return new SeataLoadBalancerFeignClient(client.getDelegate(), this.factory(), this.clientFactory(), this.beanFactory);
            }
            if (bean.getClass().getName().equals("org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient")) {
                return new SeataFeignBlockingLoadBalancerClient(this.getClient(bean), (BlockingLoadBalancerClient)this.beanFactory.getBean(BlockingLoadBalancerClient.class));
            }
            return new SeataFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(Object bean) {
        Field client = null;
        boolean oldAccessible = false;
        try {
            client = bean.getClass().getDeclaredField("delegate");
            oldAccessible = client.isAccessible();
            client.setAccessible(true);
            Client client2 = (Client)client.get(bean);
            return client2;
        }
        catch (Exception e) {
            LOG.error((Object)"get delegate client error", (Throwable)e);
        }
        finally {
            client.setAccessible(oldAccessible);
        }
        return null;
    }

    CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    SpringClientFactory clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = (SpringClientFactory)this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }
}

