/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.loader;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigAgentWatcher {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAgentWatcher.class);
    private final Map<Path, ChangeCallback> watchedFolders = new ConcurrentHashMap<Path, ChangeCallback>();
    private final Map<Path, Map<Path, Long>> watchedYamlFiles = new ConcurrentHashMap<Path, Map<Path, Long>>();
    private final ScheduledExecutorService fileWatcher = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean started = false;

    ConfigAgentWatcher() {
    }

    synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("ConfigAgentWatcher is already started");
        }
        logger.info("Starting ConfigAgentWatcher");
        this.fileWatcher.scheduleAtFixedRate(this::checkForChanges, 2L, 2L, TimeUnit.SECONDS);
        this.started = true;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        logger.info("ConfigAgentWatcher started successfully. Watching {} folders.", (Object)this.watchedFolders.size());
    }

    synchronized void stop() {
        if (!this.started) {
            return;
        }
        logger.info("Stopping ConfigAgentWatcher...");
        this.fileWatcher.shutdown();
        try {
            if (!this.fileWatcher.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.fileWatcher.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.fileWatcher.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.started = false;
        logger.info("ConfigAgentWatcher stopped.");
    }

    void watch(Path agentDirPath, ChangeCallback callback) {
        if (!Files.isDirectory(agentDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Config folder does not exist: " + agentDirPath);
        }
        this.watchedFolders.put(agentDirPath, callback);
        Map<Path, Long> yamlFiles = this.scanYamlFiles(agentDirPath);
        this.watchedYamlFiles.put(agentDirPath, yamlFiles);
        logger.debug("Now watching {} YAML files in agent folder: {}", (Object)yamlFiles.size(), (Object)agentDirPath);
    }

    private Map<Path, Long> scanYamlFiles(Path agentDirPath) {
        HashMap<Path, Long> yamlFiles = new HashMap<Path, Long>();
        try (Stream<Path> files = Files.walk(agentDirPath, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".yaml") || path.toString().toLowerCase().endsWith(".yml")).forEach(yamlFile -> {
                long lastModified = this.getLastModified((Path)yamlFile);
                yamlFiles.put((Path)yamlFile, lastModified);
                logger.trace("Found YAML file: {} (modified: {})", yamlFile, (Object)lastModified);
            });
        }
        catch (IOException e) {
            logger.warn("Failed to scan YAML files in: {}", (Object)agentDirPath, (Object)e);
        }
        return yamlFiles;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void checkForChanges() {
        for (Map.Entry<Path, ChangeCallback> entry : new HashMap<Path, ChangeCallback>(this.watchedFolders).entrySet()) {
            Path agentDirPath = entry.getKey();
            ChangeCallback callback = entry.getValue();
            try {
                this.checkDirectoryForChanges(agentDirPath, callback);
            }
            catch (Exception e) {
                logger.error("Error checking directory for changes: {}", (Object)agentDirPath, (Object)e);
            }
        }
    }

    private void checkDirectoryForChanges(Path agentDirPath, ChangeCallback callback) {
        if (!Files.isDirectory(agentDirPath, new LinkOption[0])) {
            this.handleDirectoryDeleted(agentDirPath);
            return;
        }
        Map<Path, Long> currentYamlFiles = this.watchedYamlFiles.get(agentDirPath);
        if (currentYamlFiles == null) {
            return;
        }
        Map<Path, Long> freshYamlFiles = this.scanYamlFiles(agentDirPath);
        boolean hasChanges = false;
        for (Map.Entry<Path, Long> freshEntry : freshYamlFiles.entrySet()) {
            Path yamlFile = freshEntry.getKey();
            long currentModified = freshEntry.getValue();
            Long previousModified = currentYamlFiles.get(yamlFile);
            if (previousModified == null) {
                logger.info("Detected new YAML file: {}", (Object)yamlFile);
                hasChanges = true;
                continue;
            }
            if (currentModified <= previousModified) continue;
            logger.info("Detected change in YAML file: {}", (Object)yamlFile);
            hasChanges = true;
        }
        for (Path trackedFile : currentYamlFiles.keySet()) {
            if (freshYamlFiles.containsKey(trackedFile)) continue;
            logger.info("Detected deleted YAML file: {}", (Object)trackedFile);
            hasChanges = true;
        }
        if (hasChanges) {
            this.watchedYamlFiles.put(agentDirPath, freshYamlFiles);
            callback.onConfigChanged(agentDirPath);
        }
    }

    private void handleDirectoryDeleted(Path agentDirPath) {
        logger.info("Agent directory deleted: {}", (Object)agentDirPath);
        ChangeCallback callback = this.watchedFolders.remove(agentDirPath);
        this.watchedYamlFiles.remove(agentDirPath);
        if (callback != null) {
            callback.onConfigChanged(agentDirPath);
        }
    }

    private long getLastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            logger.warn("Could not get last modified time for: {}", (Object)path, (Object)e);
            return 0L;
        }
    }

    @FunctionalInterface
    static interface ChangeCallback {
        public void onConfigChanged(Path var1);
    }
}

