/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.InterruptionMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ToolRequestConfirmMessageDTO
implements MessageDTO {
    @JsonProperty(value="messageType")
    private String messageType = "tool-confirm";
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @JsonProperty(value="toolFeedback")
    private List<ToolFeedback> toolFeedback = new ArrayList<ToolFeedback>();

    public ToolRequestConfirmMessageDTO() {
    }

    public ToolRequestConfirmMessageDTO(String content) {
        this();
        this.content = content;
    }

    public ToolRequestConfirmMessageDTO(InterruptionMetadata interruptionMetadata) {
        this();
        this.content = "";
        this.metadata = new HashMap<String, Object>(interruptionMetadata.metadata().orElse(Map.of()));
        if (interruptionMetadata.toolFeedbacks() != null && !interruptionMetadata.toolFeedbacks().isEmpty()) {
            this.toolFeedback = new ArrayList<ToolFeedback>();
            for (InterruptionMetadata.ToolFeedback feedback : interruptionMetadata.toolFeedbacks()) {
                ToolFeedback toolFeedback = new ToolFeedback();
                toolFeedback.setId(feedback.getId());
                toolFeedback.setName(feedback.getName());
                toolFeedback.setArguments(feedback.getArguments());
                toolFeedback.setDescription(feedback.getDescription());
                if (feedback.getResult() != null) {
                    toolFeedback.setResult(ToolFeedback.FeedbackResult.valueOf(feedback.getResult().name()));
                }
                this.toolFeedback.add(toolFeedback);
            }
        }
    }

    public InterruptionMetadata toInterruptionMetadata(String nodeId, OverAllState state) {
        InterruptionMetadata.Builder builder = InterruptionMetadata.builder((String)nodeId, (OverAllState)state);
        if (this.metadata != null) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                builder.addMetadata(entry.getKey(), entry.getValue());
            }
        }
        if (this.toolFeedback != null && !this.toolFeedback.isEmpty()) {
            for (ToolFeedback feedback : this.toolFeedback) {
                InterruptionMetadata.ToolFeedback.FeedbackResult result = feedback.getResult() != null ? InterruptionMetadata.ToolFeedback.FeedbackResult.valueOf((String)feedback.getResult().name()) : InterruptionMetadata.ToolFeedback.FeedbackResult.APPROVED;
                InterruptionMetadata.ToolFeedback interruptionToolFeedback = new InterruptionMetadata.ToolFeedback(feedback.getId(), feedback.getName(), feedback.getArguments(), result, feedback.getDescription());
                builder.addToolFeedback(interruptionToolFeedback);
            }
        }
        return builder.build();
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public List<ToolFeedback> getToolFeedback() {
        return this.toolFeedback;
    }

    public void setToolFeedback(List<ToolFeedback> toolFeedback) {
        this.toolFeedback = toolFeedback;
    }

    public static class ToolFeedback {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="arguments")
        private String arguments;
        @JsonProperty(value="result")
        private FeedbackResult result;
        @JsonProperty(value="description")
        private String description;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getArguments() {
            return this.arguments;
        }

        public void setArguments(String arguments) {
            this.arguments = arguments;
        }

        public FeedbackResult getResult() {
            return this.result;
        }

        public void setResult(FeedbackResult result) {
            this.result = result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public static enum FeedbackResult {
            APPROVED,
            REJECTED,
            EDITED;

        }
    }
}

