/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.tool.observation;

import com.alibaba.cloud.ai.tool.observation.ArmsToolCallingObservationContext;
import com.alibaba.cloud.ai.tool.observation.ArmsToolCallingObservationDocumentation;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import org.springframework.util.StringUtils;

public class ArmsToolCallingObservationConvention
implements ObservationConvention<ArmsToolCallingObservationContext> {
    public static final String DEFAULT_OPERATION_NAME = "execute_tool";
    public static final String SPAN_KIND = "TOOL";
    public static final String FRAMEWORK = "spring ai alibaba";

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ArmsToolCallingObservationContext;
    }

    public String getName() {
        return DEFAULT_OPERATION_NAME;
    }

    public String getContextualName(ArmsToolCallingObservationContext context) {
        if (StringUtils.hasText((String)context.getToolCall().name())) {
            return "%s %s".formatted(DEFAULT_OPERATION_NAME, context.getToolCall().name());
        }
        return DEFAULT_OPERATION_NAME;
    }

    public KeyValues getLowCardinalityKeyValues(ArmsToolCallingObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.spanKind(context), this.framework(context)});
    }

    protected KeyValue aiOperationType(ArmsToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ArmsToolCallingObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)DEFAULT_OPERATION_NAME);
    }

    protected KeyValue spanKind(ArmsToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ArmsToolCallingObservationDocumentation.LowCardinalityKeyNames.GEN_AI_SPAN_KIND, (String)SPAN_KIND);
    }

    protected KeyValue framework(ArmsToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ArmsToolCallingObservationDocumentation.LowCardinalityKeyNames.GEN_AI_FRAMEWORK, (String)FRAMEWORK);
    }

    public KeyValues getHighCardinalityKeyValues(ArmsToolCallingObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.toolCallId(keyValues, context);
        keyValues = this.toolCallName(keyValues, context);
        keyValues = this.toolDescription(keyValues, context);
        keyValues = this.toolParameters(keyValues, context);
        keyValues = this.returnDirect(keyValues, context);
        keyValues = this.outputValue(keyValues, context);
        return keyValues;
    }

    protected KeyValues toolCallId(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        if (context.getToolCall().id() != null) {
            return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.GEN_AI_TOOL_CALL_ID.asString(), String.valueOf(context.getToolCall().id()));
        }
        return keyValues;
    }

    protected KeyValues toolCallName(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        if (context.getToolCall().name() != null) {
            return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.GEN_AI_TOOL_NAME.asString(), String.valueOf(context.getToolCall().name())).and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_NAME.asString(), String.valueOf(context.getToolCall().name()));
        }
        return keyValues;
    }

    protected KeyValues toolDescription(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_DESCRIPTION.asString(), context.getDescription());
    }

    protected KeyValues toolParameters(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        if (context.getToolCall().arguments() != null) {
            return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_PARAMETERS.asString(), context.getToolCall().arguments()).and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.INPUT_VALUE.asString(), context.getToolCall().arguments());
        }
        return keyValues;
    }

    protected KeyValues returnDirect(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_RETURN_DIRECT.asString(), String.valueOf(context.isReturnDirect()));
    }

    protected KeyValues outputValue(KeyValues keyValues, ArmsToolCallingObservationContext context) {
        if (StringUtils.hasText((String)context.getToolResult())) {
            return keyValues.and(ArmsToolCallingObservationDocumentation.HighCardinalityKeyNames.OUTPUT_VALUE.asString(), context.getToolResult());
        }
        return keyValues;
    }
}

