/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.dashscope;

import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeAudioTranscriptionProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeChatProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeConnectionUtils;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeEmbeddingProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeImageProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeRerankProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeSpeechSynthesisProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.ResolvedConnectionProperties;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAgentApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioTranscriptionApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeImageApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeSpeechSynthesisApi;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioTranscriptionModel;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeSpeechSynthesisModel;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatModel;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingModel;
import com.alibaba.cloud.ai.dashscope.image.DashScopeImageModel;
import com.alibaba.cloud.ai.dashscope.rerank.DashScopeRerankModel;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.function.DefaultFunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@ConditionalOnClass(value={DashScopeApi.class})
@AutoConfiguration(after={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class, WebClientAutoConfiguration.class})
@EnableConfigurationProperties(value={DashScopeConnectionProperties.class, DashScopeChatProperties.class, DashScopeImageProperties.class, DashScopeSpeechSynthesisProperties.class, DashScopeAudioTranscriptionProperties.class, DashScopeEmbeddingProperties.class, DashScopeRerankProperties.class})
public class DashScopeAutoConfiguration {
    @Bean
    public RestClientCustomizer restClientCustomizer(DashScopeConnectionProperties commonProperties) {
        return restClientBuilder -> restClientBuilder.requestFactory(ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS.withReadTimeout(Duration.ofSeconds(commonProperties.getReadTimeout().intValue()))));
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackResolver springAiFunctionManager(ApplicationContext context) {
        DefaultFunctionCallbackResolver manager = new DefaultFunctionCallbackResolver();
        manager.setApplicationContext(context);
        return manager;
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.rerank", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeRerankConfiguration {
        protected DashScopeRerankConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeRerankModel dashscopeRerankModel(DashScopeConnectionProperties commonProperties, DashScopeRerankProperties rerankProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, rerankProperties, "rerank");
            DashScopeApi dashscopeApi = new DashScopeApi(resolved.baseUrl(), resolved.apiKey(), resolved.workspaceId(), restClientBuilder, webClientBuilder, responseErrorHandler);
            return new DashScopeRerankModel(dashscopeApi, rerankProperties.getOptions(), retryTemplate);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.audio.transcription", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeAudioTranscriptionConfiguration {
        protected DashScopeAudioTranscriptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeAudioTranscriptionModel dashScopeAudioTranscriptionModel(DashScopeConnectionProperties commonProperties, DashScopeAudioTranscriptionProperties audioTranscriptionProperties, RetryTemplate retryTemplate) {
            DashScopeAudioTranscriptionApi dashScopeAudioTranscriptionApi = this.dashScopeAudioTranscriptionApi(commonProperties, audioTranscriptionProperties);
            return new DashScopeAudioTranscriptionModel(dashScopeAudioTranscriptionApi, audioTranscriptionProperties.getOptions(), retryTemplate);
        }

        private DashScopeAudioTranscriptionApi dashScopeAudioTranscriptionApi(DashScopeConnectionProperties commonProperties, DashScopeAudioTranscriptionProperties audioTranscriptionProperties) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, audioTranscriptionProperties, "audio.transcription");
            return new DashScopeAudioTranscriptionApi(resolved.apiKey());
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.audio.synthesis", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeSpeechSynthesisConfiguration {
        protected DashScopeSpeechSynthesisConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeSpeechSynthesisModel dashScopeSpeechSynthesisModel(DashScopeConnectionProperties commonProperties, DashScopeSpeechSynthesisProperties speechSynthesisProperties, RetryTemplate retryTemplate) {
            DashScopeSpeechSynthesisApi dashScopeSpeechSynthesisApi = this.dashScopeSpeechSynthesisApi(commonProperties, speechSynthesisProperties);
            return new DashScopeSpeechSynthesisModel(dashScopeSpeechSynthesisApi, speechSynthesisProperties.getOptions(), retryTemplate);
        }

        private DashScopeSpeechSynthesisApi dashScopeSpeechSynthesisApi(DashScopeConnectionProperties commonProperties, DashScopeSpeechSynthesisProperties speechSynthesisProperties) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, speechSynthesisProperties, "audio.synthesis");
            return new DashScopeSpeechSynthesisApi(resolved.apiKey());
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeEmbeddingConfiguration {
        protected DashScopeEmbeddingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeEmbeddingModel dashscopeEmbeddingModel(DashScopeConnectionProperties commonProperties, DashScopeEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
            DashScopeApi dashScopeApi = this.dashscopeEmbeddingApi(commonProperties, embeddingProperties, restClientBuilder, webClientBuilder, responseErrorHandler);
            DashScopeEmbeddingModel embeddingModel = new DashScopeEmbeddingModel(dashScopeApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
            observationConvention.ifAvailable(arg_0 -> ((DashScopeEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
            return embeddingModel;
        }

        private DashScopeApi dashscopeEmbeddingApi(DashScopeConnectionProperties commonProperties, DashScopeEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, embeddingProperties, "embedding");
            return new DashScopeApi(resolved.baseUrl(), resolved.apiKey(), resolved.workspaceId(), restClientBuilder, webClientBuilder, responseErrorHandler);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeImageConfiguration {
        protected DashScopeImageConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeImageModel dashScopeImageModel(DashScopeConnectionProperties commonProperties, DashScopeImageProperties imageProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, imageProperties, "image");
            DashScopeImageApi dashScopeImageApi = new DashScopeImageApi(resolved.baseUrl(), resolved.apiKey(), resolved.workspaceId(), restClientBuilder, webClientBuilder, responseErrorHandler);
            DashScopeImageModel dashScopeImageModel = new DashScopeImageModel(dashScopeImageApi, imageProperties.getOptions(), retryTemplate);
            return dashScopeImageModel;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.ai.dashscope.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DashScopeChatConfiguration {
        protected DashScopeChatConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DashScopeChatModel dashscopeChatModel(DashScopeConnectionProperties commonProperties, DashScopeChatProperties chatProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackResolver functionCallbackResolver, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
            DashScopeApi dashscopeApi = this.dashscopeChatApi(commonProperties, chatProperties, restClientBuilder, webClientBuilder, responseErrorHandler);
            DashScopeChatModel dashscopeModel = new DashScopeChatModel(dashscopeApi, chatProperties.getOptions(), functionCallbackResolver, toolFunctionCallbacks, retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
            observationConvention.ifAvailable(arg_0 -> ((DashScopeChatModel)dashscopeModel).setObservationConvention(arg_0));
            return dashscopeModel;
        }

        private DashScopeApi dashscopeChatApi(DashScopeConnectionProperties commonProperties, DashScopeChatProperties chatProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, chatProperties, "chat");
            return new DashScopeApi(resolved.baseUrl(), resolved.apiKey(), resolved.workspaceId(), restClientBuilder, webClientBuilder, responseErrorHandler);
        }

        @Bean
        public DashScopeAgentApi dashscopeAgentApi(DashScopeConnectionProperties commonProperties, DashScopeChatProperties chatProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
            ResolvedConnectionProperties resolved = DashScopeConnectionUtils.resolveConnectionProperties(commonProperties, chatProperties, "chat");
            return new DashScopeAgentApi(resolved.baseUrl(), resolved.apiKey(), resolved.workspaceId(), restClientBuilder, webClientBuilder, responseErrorHandler);
        }
    }
}

