/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.arms;

import com.alibaba.cloud.ai.autoconfigure.arms.ArmsCommonProperties;
import com.alibaba.cloud.ai.observation.client.prompt.PromptMetadataAwareChatClientObservationConvention;
import com.alibaba.cloud.ai.observation.model.ChatModelInputObservationHandler;
import com.alibaba.cloud.ai.observation.model.ChatModelOutputObservationHandler;
import com.alibaba.cloud.ai.observation.model.PromptMetadataAwareChatModelObservationConvention;
import com.alibaba.cloud.ai.tool.ObservableToolCallingManager;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={ChatModel.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.arms", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ArmsCommonProperties.class})
public class ArmsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.ai.alibaba.arms", name={"tool.enabled"}, havingValue="true")
    ToolCallingManager toolCallingManager(ToolCallbackResolver toolCallbackResolver, ToolExecutionExceptionProcessor toolExecutionExceptionProcessor, ObjectProvider<ObservationRegistry> observationRegistry) {
        return ObservableToolCallingManager.builder().observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).toolCallbackResolver(toolCallbackResolver).toolExecutionExceptionProcessor(toolExecutionExceptionProcessor).build();
    }

    @Bean
    ChatClientObservationConvention chatClientObservationConvention() {
        return new PromptMetadataAwareChatClientObservationConvention();
    }

    @Bean
    ChatModelObservationConvention chatModelObservationConvention() {
        return new PromptMetadataAwareChatModelObservationConvention();
    }

    @Bean
    @ConditionalOnMissingBean(value={ChatModelInputObservationHandler.class}, name={"chatModelInputObservationHandler"})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.arms", name={"model.capture-input"}, havingValue="true")
    ChatModelInputObservationHandler armsChatModelInputObservationHandler(ArmsCommonProperties properties) {
        return new ChatModelInputObservationHandler(properties.getModel().getMessageMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={ChatModelOutputObservationHandler.class}, name={"chatModelOutputObservationHandler"})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.arms", name={"model.capture-output"}, havingValue="true")
    ChatModelOutputObservationHandler armsChatModelOutputObservationHandler(ArmsCommonProperties properties) {
        return new ChatModelOutputObservationHandler(properties.getModel().getMessageMode());
    }
}

