/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;

public class SequentialGraphBuildingStrategy
implements FlowGraphBuildingStrategy {
    @Override
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateConfig(config);
        this.validateSequentialConfig(config);
        StateGraph graph = new StateGraph(config.getName(), config.getKeyStrategyFactory());
        Agent rootAgent = config.getRootAgent();
        graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        graph.addEdge("__START__", rootAgent.name());
        Agent currentAgent = rootAgent;
        for (Agent subAgent : config.getSubAgents()) {
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, graph);
            graph.addEdge(currentAgent.name(), subAgent.name());
            currentAgent = subAgent;
        }
        graph.addEdge(currentAgent.name(), "__END__");
        return graph;
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.SEQUENTIAL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        FlowGraphBuildingStrategy.super.validateConfig(config);
        this.validateSequentialConfig(config);
    }

    private void validateSequentialConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getSubAgents() == null || config.getSubAgents().isEmpty()) {
            throw new IllegalArgumentException("Sequential flow requires at least one sub-agent");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Sequential flow requires root agent to be a FlowAgent");
        }
    }
}

