/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.loop.LoopStrategy;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.state.strategy.ReplaceStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LoopGraphBuildingStrategy
implements FlowGraphBuildingStrategy {
    @Override
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateConfig(config);
        StateGraph graph = new StateGraph(config.getName(), config.getKeyStrategyFactory());
        Agent rootAgent = config.getRootAgent();
        graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        graph.addEdge("__START__", rootAgent.name());
        LoopStrategy loopStrategy = (LoopStrategy)config.getCustomProperty("loopStrategy");
        graph.addNode(loopStrategy.loopInitNodeName(), AsyncNodeAction.node_async(loopStrategy::loopInit));
        graph.addEdge(rootAgent.name(), loopStrategy.loopInitNodeName());
        graph.addNode(loopStrategy.loopDispatchNodeName(), AsyncNodeAction.node_async(loopStrategy::loopDispatch));
        graph.addEdge(loopStrategy.loopInitNodeName(), loopStrategy.loopDispatchNodeName());
        Agent subAgent = config.getSubAgents().get(0);
        graph.addNode(subAgent.name(), subAgent.getGraph());
        graph.addConditionalEdges(loopStrategy.loopDispatchNodeName(), AsyncEdgeAction.edge_async(state -> {
            Boolean value = (Boolean)state.value(loopStrategy.loopFlagKey(), (Object)false);
            return value != false ? "continue" : "break";
        }), Map.of("continue", subAgent.name(), "break", "__END__"));
        graph.addEdge(subAgent.name(), loopStrategy.loopDispatchNodeName());
        return graph;
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.LOOP.getType();
    }

    @Override
    public KeyStrategyFactory generateKeyStrategyFactory(FlowGraphBuilder.FlowGraphConfig config) {
        KeyStrategyFactory factory = FlowGraphBuildingStrategy.super.generateKeyStrategyFactory(config);
        return () -> {
            Map map1 = factory.apply();
            LoopStrategy loopStrategy = (LoopStrategy)config.getCustomProperty("loopStrategy");
            Map<String, KeyStrategy> map2 = loopStrategy.tempKeys().stream().collect(Collectors.toMap(k -> k, k -> new ReplaceStrategy(), (k1, k2) -> k1));
            return Stream.of(map1, map2).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k1));
        };
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        FlowGraphBuildingStrategy.super.validateConfig(config);
        Object object = config.getCustomProperty("loopStrategy");
        if (!(object instanceof LoopStrategy)) {
            throw new IllegalArgumentException("loopStrategy must be an instance of LoopStrategy");
        }
        List<Agent> subAgents = config.getSubAgents();
        if (subAgents.size() != 1) {
            throw new IllegalArgumentException("loopAgent must have only one subAgent");
        }
    }
}

