/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.agent.Builder;
import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.interceptor.Interceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.agent.node.AgentLlmNode;
import com.alibaba.cloud.ai.graph.agent.node.AgentToolNode;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.StringUtils;

public class DefaultBuilder
extends Builder {
    @Override
    public ReactAgent build() {
        if (!StringUtils.hasText((String)this.name)) {
            throw new IllegalArgumentException("Agent name must not be empty");
        }
        if (this.chatClient == null && this.model == null) {
            throw new IllegalArgumentException("Either chatClient or model must be provided");
        }
        if (this.chatClient == null) {
            ChatClient.Builder clientBuilder = ChatClient.builder((ChatModel)this.model, (ObservationRegistry)(this.observationRegistry == null ? ObservationRegistry.NOOP : this.observationRegistry), (ChatClientObservationConvention)this.customObservationConvention);
            if (this.chatOptions != null) {
                clientBuilder.defaultOptions(this.chatOptions);
            }
            this.chatClient = clientBuilder.build();
        }
        AgentLlmNode.Builder llmNodeBuilder = AgentLlmNode.builder().agentName(this.name).chatClient(this.chatClient);
        if (this.outputKey != null && !this.outputKey.isEmpty()) {
            llmNodeBuilder.outputKey(this.outputKey);
        }
        if (this.systemPrompt != null) {
            llmNodeBuilder.systemPrompt(this.systemPrompt);
        }
        String outputSchema = null;
        if (StringUtils.hasLength((String)this.outputSchema)) {
            outputSchema = this.outputSchema;
        } else if (this.outputType != null) {
            BeanOutputConverter formatProvider = new BeanOutputConverter(this.outputType);
            outputSchema = formatProvider.getFormat();
        }
        if (StringUtils.hasLength((String)outputSchema)) {
            llmNodeBuilder.outputSchema(outputSchema);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.interceptors)) {
            this.modelInterceptors = new ArrayList();
            this.toolInterceptors = new ArrayList();
            for (Interceptor interceptor2 : this.interceptors) {
                if (interceptor2 instanceof ModelInterceptor) {
                    this.modelInterceptors.add((ModelInterceptor)interceptor2);
                }
                if (!(interceptor2 instanceof ToolInterceptor)) continue;
                this.toolInterceptors.add((ToolInterceptor)interceptor2);
            }
        }
        ArrayList regularTools = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.tools)) {
            regularTools.addAll(this.tools);
        }
        List<Object> interceptorTools = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.modelInterceptors)) {
            interceptorTools = this.modelInterceptors.stream().flatMap(interceptor -> interceptor.getTools().stream()).toList();
        }
        ArrayList<ToolCallback> allTools = new ArrayList<ToolCallback>();
        allTools.addAll(interceptorTools);
        allTools.addAll(regularTools);
        if (CollectionUtils.isNotEmpty(allTools)) {
            llmNodeBuilder.toolCallbacks(allTools);
        }
        if (this.enableLogging) {
            llmNodeBuilder.enableReasoningLog(true);
        }
        AgentLlmNode llmNode = llmNodeBuilder.build();
        AgentToolNode.Builder toolBuilder = AgentToolNode.builder().agentName(this.name);
        if (this.resolver != null) {
            toolBuilder.toolCallbackResolver(this.resolver);
        }
        if (CollectionUtils.isNotEmpty(allTools)) {
            toolBuilder.toolCallbacks(allTools);
        }
        if (this.enableLogging) {
            toolBuilder.enableActingLog(true);
        }
        AgentToolNode toolNode = toolBuilder.build();
        return new ReactAgent(llmNode, toolNode, this.buildConfig(), this);
    }
}

