/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.alibaba.middleware.ushura.Chooser;
import com.alibaba.ans.shaded.com.alibaba.middleware.ushura.Pair;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.UnitCache;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.MotionFlow;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.HttpClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.IOUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class Balancer {
    public static List<String> unconsistentDomWithAddressServer = new CopyOnWriteArrayList<String>();

    protected static List<Host> filterAndDuplicate(List<Host> hosts) {
        if (hosts == null) {
            return null;
        }
        ArrayList<Host> duplicated = new ArrayList<Host>();
        for (Host host : hosts) {
            if (!host.isValid()) continue;
            for (int i = 0; i < host.getWeight(); ++i) {
                duplicated.add(host);
            }
        }
        return duplicated;
    }

    protected static Host getHostByRandomWeight(List<Host> hosts) {
        VIPClient.LOG.debug("entry randomWithWeight");
        if (hosts == null || hosts.size() == 0) {
            VIPClient.LOG.debug("hosts == null || hosts.size() == 0");
            return null;
        }
        Chooser vipChooser = new Chooser("www.taobao.com");
        VIPClient.LOG.debug("new Chooser");
        ArrayList hostsWithWeight = new ArrayList();
        for (Host host : hosts) {
            if (!host.isValid()) continue;
            hostsWithWeight.add(new Pair<Host>(host, host.getDoubleWeight()));
        }
        VIPClient.LOG.debug("for (Host host : hosts)");
        vipChooser.refresh(hostsWithWeight);
        VIPClient.LOG.debug("vipChooser.refresh");
        Host host = (Host)vipChooser.randomWithWeight();
        return host;
    }

    public static class Unit {
        private static ConcurrentMap<String, DomEntry> DOM_ENTRY_MAP = new ConcurrentHashMap<String, DomEntry>();

        public static List<Host> selectAll(Domain dom, long userId) {
            List<Host> hosts = Unit.getUnitEntry(dom, userId).getHosts();
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for dom: " + dom.getName() + "of userId: " + userId);
            }
            return Balancer.filterAndDuplicate(hosts);
        }

        public static Host selectHost(Domain dom, long userId) {
            List<Host> hosts = Unit.selectAll(dom, userId);
            MotionFlow.enter(dom.getName());
            return Balancer.getHostByRandomWeight(hosts);
        }

        public static List<Host> nothing(Domain dom, long userId) {
            return Unit.getUnitEntry(dom, userId).getHosts();
        }

        private static UnitEntry getUnitEntry(Domain dom, long userId) {
            String unit;
            DomEntry domEntry = (DomEntry)DOM_ENTRY_MAP.get(dom.getKey());
            if (domEntry == null) {
                UnitMapGenerator listener = new UnitMapGenerator(dom);
                listener.ipChanged(dom.getHosts());
                domEntry = (DomEntry)DOM_ENTRY_MAP.get(dom.getKey());
                VIPClient.listen(dom.getName(), listener);
            }
            if (StringUtils.isEmpty(unit = UnitCache.getUnit(userId))) {
                throw new IllegalArgumentException("unable to figure unit for userId:" + userId);
            }
            UnitEntry unitEntry = (UnitEntry)domEntry.unitEntryMap.get(unit);
            if (unitEntry == null) {
                throw new IllegalArgumentException("no ip matches unit: " + unit + "of userId: " + userId);
            }
            return unitEntry;
        }

        private static class UnitMapGenerator
        implements HostListener {
            Domain dom;

            public UnitMapGenerator(Domain dom) {
                this.dom = dom;
            }

            @Override
            public void ipChanged(List<Host> hosts) {
                DomEntry domEntry = new DomEntry();
                for (Host host : hosts) {
                    UnitEntry unitEntry;
                    String unit = host.getUnit();
                    if (StringUtils.isEmpty(unit)) {
                        unit = "unknown__";
                    }
                    if ((unitEntry = (UnitEntry)domEntry.unitEntryMap.get(unit)) == null) {
                        domEntry.unitEntryMap.putIfAbsent(unit, new UnitEntry());
                        unitEntry = (UnitEntry)domEntry.unitEntryMap.get(unit);
                    }
                    unitEntry.hosts.add(host);
                }
                DOM_ENTRY_MAP.put(this.dom.getKey(), domEntry);
            }
        }

        private static class UnitEntry {
            private List<Host> hosts = new ArrayList<Host>();

            private UnitEntry() {
            }

            public List<Host> getHosts() {
                return new ArrayList<Host>(this.hosts);
            }
        }

        private static class DomEntry {
            public ConcurrentMap<String, UnitEntry> unitEntryMap = new ConcurrentHashMap<String, UnitEntry>();

            private DomEntry() {
            }
        }
    }

    public static class RR {
        private static ConcurrentMap<String, AtomicLong> POS_MAP = new ConcurrentHashMap<String, AtomicLong>();

        public static List<Host> selectAll(Domain dom) {
            List<Host> hosts = RR.useAddressServerIfNecessary(dom);
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for dom: " + dom.getName());
            }
            return Balancer.filterAndDuplicate(hosts);
        }

        public static List<Host> selectAllFromSpecifiedURL(Domain domain) {
            String dom = domain.getName();
            String url = domain.getSpecifiedURL();
            if (StringUtils.isEmpty(url)) {
                return Collections.emptyList();
            }
            HttpClient.HttpResult httpResult = HttpClient.httpGet(url, null, null, "GBK");
            if (httpResult.code != 200) {
                VIPClient.LOG.error("NA", "no host to returned from address server, url: " + url);
                return Collections.emptyList();
            }
            String content = httpResult.content;
            ArrayList<String> list = new ArrayList<String>();
            try {
                for (String line : IOUtils.readLines(new StringReader(content))) {
                    if (line.trim().isEmpty()) continue;
                    list.add(line.trim());
                }
            }
            catch (IOException e) {
                VIPClient.LOG.warn("can not get data from url: " + url);
            }
            if (list.isEmpty()) {
                throw new IllegalStateException("no host to srv for dom: " + domain.getName());
            }
            ArrayList<Host> hosts = new ArrayList<Host>();
            for (String ip : list) {
                Host host = new Host();
                host.setIp(ip);
                host.setWeight(1);
                host.setValid(true);
                host.setPort(-1);
                hosts.add(host);
            }
            return hosts;
        }

        public static List<Host> useAddressServerIfNecessary(Domain dom) {
            List<Host> hosts = dom.getHosts();
            return hosts;
        }

        public static Host selectHost(Domain dom) {
            List<Host> hosts = RR.useAddressServerIfNecessary(dom);
            if (CollectionUtils.isEmpty(hosts)) {
                throw new IllegalStateException("no host to srv for dom: " + dom.getName());
            }
            MotionFlow.enter(dom.getName());
            return Balancer.getHostByRandomWeight(hosts);
        }

        public static List<Host> nothing(Domain dom) {
            return dom.getHosts();
        }
    }
}

