/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ElisionTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> articles;
    @Nullable
    private final String articlesPath;
    @Nullable
    private final Boolean articlesCase;
    public static final JsonpDeserializer<ElisionTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElisionTokenFilter::setupElisionTokenFilterDeserializer);

    private ElisionTokenFilter(Builder builder) {
        super(builder);
        this.articles = ApiTypeHelper.unmodifiable(builder.articles);
        this.articlesPath = builder.articlesPath;
        this.articlesCase = builder.articlesCase;
    }

    public static ElisionTokenFilter of(Function<Builder, ObjectBuilder<ElisionTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Elision;
    }

    public final List<String> articles() {
        return this.articles;
    }

    @Nullable
    public final String articlesPath() {
        return this.articlesPath;
    }

    @Nullable
    public final Boolean articlesCase() {
        return this.articlesCase;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "elision");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.articles)) {
            generator.writeKey("articles");
            generator.writeStartArray();
            for (String item0 : this.articles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.articlesPath != null) {
            generator.writeKey("articles_path");
            generator.write(this.articlesPath);
        }
        if (this.articlesCase != null) {
            generator.writeKey("articles_case");
            generator.write(this.articlesCase.booleanValue());
        }
    }

    protected static void setupElisionTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::articles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "articles");
        op.add(Builder::articlesPath, JsonpDeserializer.stringDeserializer(), "articles_path");
        op.add(Builder::articlesCase, JsonpDeserializer.booleanDeserializer(), "articles_case");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ElisionTokenFilter> {
        @Nullable
        private List<String> articles;
        @Nullable
        private String articlesPath;
        @Nullable
        private Boolean articlesCase;

        public final Builder articles(List<String> list) {
            this.articles = Builder._listAddAll(this.articles, list);
            return this;
        }

        public final Builder articles(String value, String ... values) {
            this.articles = Builder._listAdd(this.articles, value, values);
            return this;
        }

        public final Builder articlesPath(@Nullable String value) {
            this.articlesPath = value;
            return this;
        }

        public final Builder articlesCase(@Nullable Boolean value) {
            this.articlesCase = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElisionTokenFilter build() {
            this._checkSingleUse();
            return new ElisionTokenFilter(this);
        }
    }
}

