/*
 * Decompiled with CFR 0.152.
 */
package com.office.tools;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);
    static String COMMA = ".";

    public static String getFileExtension(String name) {
        return FileNameUtil.extName((String)name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileByte(String url) {
        try (InputStream in = new URL(url).openConnection().getInputStream();){
            byte[] byArray = IoUtil.readBytes((InputStream)in);
            return byArray;
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u5931\u8d25:" + e.getMessage());
            return new byte[0];
        }
    }

    public static String ConvertStreamToString(InputStream stream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            stringBuilder.append(line);
            line = bufferedReader.readLine();
        }
        String result = stringBuilder.toString();
        return result;
    }

    public static InputStream openInputStream(File file) {
        return IoUtil.toStream((File)file);
    }

    public static void downloadInline(File file, String name, HttpServletResponse response) {
        try {
            byte[] buffer = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream fis = new BufferedInputStream(fileInputStream);
            buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            FileUtil.dowInline(buffer, name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadInline(String path, String name, HttpServletResponse response) {
        logger.info("\u6587\u4ef6\u4e0b\u8f7d:" + path);
        byte[] buffer = null;
        try {
            if (path.startsWith("http")) {
                buffer = FileUtil.getFileByte(path);
                FileUtil.dowInline(buffer, name, response);
            } else {
                File file = new File(path);
                FileUtil.downloadInline(file, name, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadInline(byte[] bytes, String name, HttpServletResponse response) {
        logger.info("\u6587\u4ef6\u4e0b\u8f7d:" + name);
        FileUtil.dowInline(bytes, name, response);
    }

    public static void downloadAttachment(File file, String name, HttpServletResponse response) {
        try {
            byte[] buffer = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream fis = new BufferedInputStream(fileInputStream);
            buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            FileUtil.attachment(buffer, name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadAttachment(String path, String name, HttpServletResponse response) {
        logger.info("\u6587\u4ef6\u4e0b\u8f7d:" + path);
        byte[] buffer = null;
        try {
            if (path.startsWith("http")) {
                buffer = FileUtil.getFileByte(path);
                FileUtil.downloadAttachment(buffer, name, response);
            } else {
                File file = new File(path);
                FileUtil.downloadAttachment(file, name, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadAttachment(byte[] bytes, String name, HttpServletResponse response) {
        FileUtil.attachment(bytes, name, response);
    }

    private static void attachment(byte[] bytes, String name, HttpServletResponse response) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType(FileUtil.getContentType(name));
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(name, "UTF-8"));
            response.addHeader("Content-Length", "" + bytes.length);
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)outputStream).write(bytes);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void dowInline(byte[] bytes, String name, HttpServletResponse response) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType(FileUtil.getContentType(name));
            response.addHeader("Content-Disposition", "inline;filename=" + URLEncoder.encode(name, "UTF-8"));
            response.addHeader("Content-Length", "" + bytes.length);
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)outputStream).write(bytes);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getContentType(String returnFileName) {
        String contentType = "application/octet-stream";
        if (returnFileName.lastIndexOf(COMMA) < 0) {
            return contentType;
        }
        returnFileName = returnFileName.toLowerCase();
        switch (returnFileName = returnFileName.substring(returnFileName.lastIndexOf(".") + 1)) {
            case "html": 
            case "htm": 
            case "shtml": {
                contentType = "text/html";
                break;
            }
            case "apk": {
                contentType = "application/vnd.android.package-archive";
                break;
            }
            case "sis": {
                contentType = "application/vnd.symbian.install";
                break;
            }
            case "sisx": {
                contentType = "application/vnd.symbian.install";
                break;
            }
            case "exe": {
                contentType = "application/x-msdownload";
                break;
            }
            case "msi": {
                contentType = "application/x-msdownload";
                break;
            }
            case "css": {
                contentType = "text/css";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "js": {
                contentType = "application/x-javascript";
                break;
            }
            case "atom": {
                contentType = "application/atom+xml";
                break;
            }
            case "rss": {
                contentType = "application/rss+xml";
                break;
            }
            case "mml": {
                contentType = "text/mathml";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "jad": {
                contentType = "text/vnd.sun.j2me.app-descriptor";
                break;
            }
            case "wml": {
                contentType = "text/vnd.wap.wml";
                break;
            }
            case "htc": {
                contentType = "text/x-component";
                break;
            }
            case "png": {
                contentType = "image/png";
                break;
            }
            case "tif": 
            case "tiff": {
                contentType = "image/tiff";
                break;
            }
            case "wbmp": {
                contentType = "image/vnd.wap.wbmp";
                break;
            }
            case "ico": {
                contentType = "image/x-icon";
                break;
            }
            case "jng": {
                contentType = "image/x-jng";
                break;
            }
            case "bmp": {
                contentType = "image/x-ms-bmp";
                break;
            }
            case "svg": {
                contentType = "image/svg+xml";
                break;
            }
            case "jar": 
            case "var": 
            case "ear": {
                contentType = "application/java-archive";
                break;
            }
            case "doc": {
                contentType = "application/msword";
                break;
            }
            case "pdf": {
                contentType = "application/pdf";
                break;
            }
            case "rtf": {
                contentType = "application/rtf";
                break;
            }
            case "xls": {
                contentType = "application/vnd.ms-excel";
                break;
            }
            case "ppt": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "7z": {
                contentType = "application/x-7z-compressed";
                break;
            }
            case "rar": {
                contentType = "application/x-rar-compressed";
                break;
            }
            case "swf": {
                contentType = "application/x-shockwave-flash";
                break;
            }
            case "rpm": {
                contentType = "application/x-redhat-package-manager";
                break;
            }
            case "der": 
            case "pem": 
            case "crt": {
                contentType = "application/x-x509-ca-cert";
                break;
            }
            case "xhtml": {
                contentType = "application/xhtml+xml";
                break;
            }
            case "zip": {
                contentType = "application/zip";
                break;
            }
            case "mid": 
            case "midi": 
            case "kar": {
                contentType = "audio/midi";
                break;
            }
            case "mp3": {
                contentType = "audio/mpeg";
                break;
            }
            case "ogg": {
                contentType = "audio/ogg";
                break;
            }
            case "m4a": {
                contentType = "audio/x-m4a";
                break;
            }
            case "ra": {
                contentType = "audio/x-realaudio";
                break;
            }
            case "3gpp": 
            case "3gp": {
                contentType = "video/3gpp";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            case "mpeg": 
            case "mpg": {
                contentType = "video/mpeg";
                break;
            }
            case "mov": {
                contentType = "video/quicktime";
                break;
            }
            case "flv": {
                contentType = "video/x-flv";
                break;
            }
            case "m4v": {
                contentType = "video/x-m4v";
                break;
            }
            case "mng": {
                contentType = "video/x-mng";
                break;
            }
            case "asx": 
            case "asf": {
                contentType = "video/x-ms-asf";
                break;
            }
            case "wmv": {
                contentType = "video/x-ms-wmv";
                break;
            }
            case "avi": {
                contentType = "video/x-msvideo";
                break;
            }
        }
        return contentType;
    }
}

