/*
 * Decompiled with CFR 0.152.
 */
package com.office.office.wps.handler;

import com.office.core.Cache;
import com.office.core.CommonConfig;
import com.office.core.FileHandler;
import com.office.core.context.FileMetadata;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPSFileHandlerImpl
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(WPSFileHandlerImpl.class);
    private CommonConfig configuration;
    private Cache cache;
    private int time = 1800;

    public WPSFileHandlerImpl(CommonConfig configuration, Cache cache) {
        this.configuration = configuration;
        this.cache = cache;
    }

    @Override
    public String getHandlerName() {
        return "wps-";
    }

    @Override
    public FileMetadata handlerFile(Map<String, Object> map, Boolean collaborativeEditing) throws Exception {
        try {
            String id = (String)map.get("fileId");
            log.info("\u6e90\u6587\u4ef6\u5b58\u50a8\u7684ID" + id);
            String key = this.getHandlerName() + id;
            if (this.cache.hasKey(key)) {
                FileMetadata fileMetadata = (FileMetadata)this.cache.get(key);
                fileMetadata.setOpenTime(new Date().getTime());
                this.cache.set(key, fileMetadata, 86400000L);
                return fileMetadata;
            }
            String tempUrl = this.getFileUri(id);
            FileMetadata tempFileInfo = FileMetadata.builder().url(tempUrl).oldName((String)map.get("fileName")).fileType((String)map.get("fileType")).fileInfo(map).key(id).openTime(new Date().getTime()).build();
            this.cache.set(key, tempFileInfo, 43200000L);
            return tempFileInfo;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void removeTempFile(String key) {
        key = this.getHandlerName() + key;
        if (this.cache.hasKey(key)) {
            this.cache.remove(key);
        }
    }

    @Override
    public FileMetadata getTempFile(String key) {
        FileMetadata tempFileInfo = (FileMetadata)this.cache.get(this.getHandlerName() + key);
        return tempFileInfo;
    }

    private String getFileUri(String id) {
        if (this.configuration.getDowloadFile().endsWith("/")) {
            return this.configuration.getDowloadFile() + id;
        }
        return this.configuration.getDowloadFile() + "/" + id;
    }
}

