/*
 * Decompiled with CFR 0.152.
 */
package com.office.office.oo.handler;

import cn.hutool.core.util.IdUtil;
import com.office.config.oo.edit.FileUser;
import com.office.core.Cache;
import com.office.core.CommonConfig;
import com.office.core.FileHandler;
import com.office.core.context.FileMetadata;
import com.office.tools.SecurityUtils;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOFileHandlerImpl
implements FileHandler {
    private static final Logger log = LoggerFactory.getLogger(OOFileHandlerImpl.class);
    private CommonConfig configuration;
    private Cache cache;
    private int time = 1800;

    public OOFileHandlerImpl(CommonConfig configuration, Cache cache) {
        this.configuration = configuration;
        this.cache = cache;
    }

    @Override
    public String getHandlerName() {
        return "onlyOffice-";
    }

    @Override
    public FileMetadata handlerFile(Map<String, Object> map, Boolean collaborativeEditing) throws Exception {
        try {
            String id = (String)map.get("fileId");
            log.info("\u6e90\u6587\u4ef6\u5b58\u50a8\u7684ID" + id);
            String key = "";
            String mode = (String)map.get("mode");
            if (mode.equals("edit")) {
                if (collaborativeEditing.booleanValue()) {
                    if (this.cache.get("collaborativeEditing_" + id) != null) {
                        key = (String)this.cache.get("collaborativeEditing_" + id);
                    } else {
                        key = IdUtil.simpleUUID();
                        this.cache.set("collaborativeEditing_" + id, key, 43200000L);
                        this.cache.set("getID_" + key, id, 43200000L);
                    }
                } else {
                    key = IdUtil.simpleUUID();
                    FileUser user = (FileUser)SecurityUtils.getUserSession();
                    this.cache.set(user.getId() + "_" + id, key);
                    this.cache.set("getID_" + key, id);
                }
            } else {
                key = id;
            }
            if (this.cache.hasKey(this.getHandlerName() + key)) {
                FileMetadata fileMetadata = (FileMetadata)this.cache.get(this.getHandlerName() + key);
                fileMetadata.setOpenTime(new Date().getTime());
                this.cache.set(this.getHandlerName() + key, fileMetadata, 43200000L);
                return fileMetadata;
            }
            String tempUrl = this.getFileUri(id);
            FileMetadata tempFileInfo = FileMetadata.builder().url(tempUrl).oldName((String)map.get("fileName")).fileType((String)map.get("fileType")).fileInfo(map).key(key).openTime(new Date().getTime()).build();
            if (mode.equals("edit")) {
                this.cache.set(this.getHandlerName() + key, tempFileInfo, 86400000L);
            }
            return tempFileInfo;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void removeTempFile(String key) {
        if (this.cache.hasKey(this.getHandlerName() + key)) {
            this.cache.remove(this.getHandlerName() + key);
        }
    }

    @Override
    public FileMetadata getTempFile(String key) {
        if (this.cache.hasKey(this.getHandlerName() + key)) {
            return (FileMetadata)this.cache.get(this.getHandlerName() + key);
        }
        return null;
    }

    private String getFileUri(String id) {
        if (this.configuration.getDowloadFile().endsWith("/")) {
            return this.configuration.getDowloadFile() + id;
        }
        return this.configuration.getDowloadFile() + "/" + id;
    }
}

