/*
 * Decompiled with CFR 0.152.
 */
package com.office.office.oo;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.office.config.BuilderConfigInfo;
import com.office.config.oo.FileConfig;
import com.office.config.oo.OnlyProperties;
import com.office.config.oo.Plugins;
import com.office.config.oo.convert.ConvertBody;
import com.office.config.oo.document.DocumentPermission;
import com.office.config.oo.edit.FileCustomization;
import com.office.config.oo.edit.FileEmbedded;
import com.office.config.oo.edit.FileUser;
import com.office.core.Cache;
import com.office.core.CommonConfig;
import com.office.core.FileHandler;
import com.office.core.SaveFileProcessor;
import com.office.core.context.FileMetadata;
import com.office.exception.OfficeException;
import com.office.tools.DocumentKey;
import com.office.tools.FileUtil;
import com.office.tools.SecurityUtils;
import com.office.tools.oo.JWTUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOOBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractOOBase.class);
    protected final CommonConfig configuration;
    protected Cache cache;
    protected FileHandler fileHandler;
    protected SaveFileProcessor saveFileProcessor;
    protected OnlyProperties onlyProperties;
    protected DocumentPermission viewPermission;
    protected DocumentPermission editPermission;
    protected FileCustomization customization;
    protected FileEmbedded embedded;
    protected Plugins plugins;
    protected JSONObject convert;
    protected String EDIT = "edit";
    protected String VIEW = "view";

    public AbstractOOBase(CommonConfig configuration) {
        this.configuration = configuration;
    }

    public void setCache(String key, String value) {
        this.cache.set(key, value);
    }

    public Integer getHistNum() {
        return this.configuration.getHistNum();
    }

    public String getCommandServiceUrl() {
        return this.onlyProperties.getDocService() + this.onlyProperties.SAVE;
    }

    public String getKey(String id) {
        FileUser user = (FileUser)SecurityUtils.getUserSession();
        if (this.cache.hasKey(user.getId() + "_" + id)) {
            return (String)this.cache.get(user.getId() + "_" + id);
        }
        return (String)this.cache.get("collaborativeEditing_" + id);
    }

    public void close(JSONObject jsonObject) {
        String key = jsonObject.getStr((Object)"key");
        FileMetadata tempFile = this.getTempFile(key);
        if (tempFile == null || new Date().getTime() < tempFile.getOpenTime()) {
            return;
        }
        int i = this.iskey(key, null);
        if (i <= 0) {
            this.removeTempFile(jsonObject);
            String fileid = (String)this.cache.get("getID_" + key);
            this.cache.remove("getID_" + key);
            this.cache.remove("collaborativeEditing_" + fileid);
            List jsonArray = (List)jsonObject.get((Object)"actions", List.class);
            String userId = (String)((Map)jsonArray.get(0)).get("userid");
            this.cache.remove(userId + "_" + fileid);
        }
    }

    public int iskey(String key, Integer users) {
        int i = 0;
        if (users != null) {
            this.cache.set(key, users);
            i = users;
        } else {
            i = (Integer)this.cache.get(key) - 1;
            if (i <= 0) {
                this.cache.remove(key);
            } else {
                this.cache.set(key, i);
            }
        }
        log.info("[" + key + "]\u6587\u6863\u4f7f\u7528\u4eba\u6570\uff1a" + i);
        return i;
    }

    public int getUserNum(String key) {
        return (Integer)this.cache.get(key);
    }

    public String getFileId(String key) {
        return (String)this.cache.get("getID_" + key);
    }

    public FileMetadata getTempFile(String key) {
        FileMetadata tempFileInfo = this.fileHandler.getTempFile(key);
        if (tempFileInfo != null) {
            return tempFileInfo;
        }
        return null;
    }

    public void removeTempFile(JSONObject jsonObject) {
        String key = (String)jsonObject.get((Object)"key");
        FileMetadata tempFileInfo = this.fileHandler.getTempFile(key);
        if (tempFileInfo != null) {
            log.info("\u4e34\u65f6\u6587\u4ef6\u4fe1\u606f\u7f13\u5b58:data:{}", (Object)key, (Object)tempFileInfo);
            this.fileHandler.removeTempFile(key);
        }
    }

    public Map openDocument(Map<String, Object> map, String mode, boolean collaborativeEditing) {
        long fileSize = (Long)map.get("fileSize");
        if (fileSize > this.configuration.getMaxSize()) {
            throw new RuntimeException("\u6587\u4ef6\u8d85\u8fc7\u3010" + this.configuration.getMaxSize() / 1024L / 1024L + "MB\u3011\u65e0\u6cd5\u6253\u5f00");
        }
        FileConfig fileConfigDTO = null;
        if (this.EDIT.equals(mode)) {
            fileConfigDTO = this.openEditConfig(map, this.EDIT, collaborativeEditing);
        }
        if (this.VIEW.equals(mode)) {
            fileConfigDTO = this.openEditConfig(map, this.VIEW, false);
        }
        String json = JSONUtil.toJsonStr((Object)fileConfigDTO);
        Map config = (Map)JSONUtil.toBean((String)json, Map.class);
        return config;
    }

    public void handlerStatus(JSONObject jsonObject) throws Exception {
        log.info("\u5f00\u59cb\u4e0b\u8f7d\u7f16\u8f91\u5668\u6587\u4ef6");
        int status = jsonObject.getInt((Object)"status");
        log.info("status[{}]:{}", (Object)status, (Object)jsonObject);
        String key = (String)jsonObject.get((Object)"key");
        FileMetadata tempFile = this.fileHandler.getTempFile(key);
        if (Objects.nonNull(tempFile)) {
            String url = jsonObject.getStr((Object)"url");
            String changesurl = jsonObject.getStr((Object)"changesurl");
            log.info("\u7f16\u8f91\u540e\u7684\u6587\u6863\u4e0b\u8f7d\u8def\u5f84url:" + url);
            log.info("\u6587\u4ef6\u53d8\u52a8\u4fe1\u606f\u6587\u4ef6url:" + changesurl);
            byte[] fileByte = FileUtil.getFileByte(url);
            byte[] changes = FileUtil.getFileByte(changesurl);
            log.info("\u4e0b\u8f7d\u7f16\u8f91\u5668\u6587\u4ef6\u6210\u529f");
            log.info("\u4fdd\u5b58\u6587\u4ef6\u524d\u7f6e\u5904\u7406");
            String fileExtension = FileUtil.getFileExtension(url);
            this.getSaveFileProcessor().saveBeforeInitialization(tempFile.getFileInfo(), fileByte, fileExtension);
            Map<String, Object> map = this.getSaveFileProcessor().save(tempFile.getFileInfo(), fileByte, changes, key);
            this.getSaveFileProcessor().saveAfterInitialization(tempFile.getFileInfo(), fileByte, fileExtension);
            tempFile.setFileInfo(map);
            this.cache.set(this.fileHandler.getHandlerName() + key, tempFile);
        } else {
            throw new OfficeException("\u6587\u4ef6\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    public String save(String key, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("c", "forcesave");
        map.put("key", key);
        map.put("userdata", userId);
        if (null != this.onlyProperties.getSecret()) {
            String token = JWTUtil.createToken(map, this.onlyProperties.getSecret());
            map.put("token", token);
        }
        String bodyString = JSONUtil.toJsonStr(map);
        log.info("forcesave:" + bodyString);
        byte[] bodyByte = bodyString.getBytes(StandardCharsets.UTF_8);
        try {
            URL url = new URL(this.onlyProperties.getDocService() + this.onlyProperties.SAVE);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setFixedLengthStreamingMode(bodyByte.length);
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(this.configuration.getTimeout());
            connection.connect();
            OutputStream os = connection.getOutputStream();
            os.write(bodyByte);
            InputStream stream = connection.getInputStream();
            if (stream == null) {
                throw new Exception("Could not get an answer");
            }
            String jsonString = FileUtil.ConvertStreamToString(stream);
            connection.disconnect();
            JSONObject jsonObj = JSONUtil.parseObj((String)jsonString);
            log.info(jsonObj.toString());
            Object error = jsonObj.get((Object)"error");
            String msg = "";
            if (error != null) {
                switch ((Integer)error) {
                    case 1: {
                        msg = "\u7f3a\u5c11\u6587\u6863\u5bc6\u94a5\u6216\u627e\u4e0d\u5230\u5177\u6709\u6b64\u7c7b\u5bc6\u94a5\u7684\u6587\u6863";
                        break;
                    }
                    case 2: {
                        msg = "\u56de\u8c03\u7f51\u5740\u4e0d\u6b63\u786e";
                        break;
                    }
                    case 3: {
                        msg = "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef";
                        break;
                    }
                    case 4: {
                        msg = "\u5728\u6536\u5230\u5f3a\u5236\u4fdd\u5b58\u547d\u4ee4\u4e4b\u524d\uff0c\u672a\u5bf9\u6587\u6863\u5e94\u7528\u4efb\u4f55\u66f4\u6539";
                        break;
                    }
                    case 5: {
                        msg = "\u547d\u4ee4\u4e0d\u6b63\u786e";
                        break;
                    }
                    case 6: {
                        msg = "\u4ee4\u724c\u65e0\u6548";
                        break;
                    }
                    default: {
                        msg = "\u4fdd\u5b58\u6210\u529f";
                    }
                }
            }
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String converted(String filetype, String key, String outputtype, String title, String password) {
        log.info("\u6587\u4ef6\u5f00\u59cb\u8f6c\u5316{}->{}", (Object)filetype, (Object)outputtype);
        String fileUrl = this.configuration.getDowloadFile() + key;
        ConvertBody body = new ConvertBody(filetype, DocumentKey.SnowflakeId(), outputtype, fileUrl, title, password, this.convert);
        String bodyString = JSONUtil.toJsonStr((Object)body);
        if (null != this.onlyProperties.getSecret()) {
            String token = JWTUtil.createToken((Map)JSONUtil.toBean((String)bodyString, Map.class), this.onlyProperties.getSecret());
            body.setToken(token);
            bodyString = JSONUtil.toJsonStr((Object)body);
        }
        log.info(bodyString);
        byte[] bodyByte = bodyString.getBytes(StandardCharsets.UTF_8);
        try {
            boolean async = body.getAsync() == null ? false : body.getAsync();
            Long resultPercent = 0L;
            String responseUri = null;
            do {
                Boolean isEndConvert;
                URL url = new URL(this.onlyProperties.getDocService() + this.onlyProperties.CONVERTER);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                connection.setFixedLengthStreamingMode(bodyByte.length);
                connection.setRequestProperty("Accept", "application/json");
                connection.setConnectTimeout(this.configuration.getTimeout());
                connection.connect();
                OutputStream os = connection.getOutputStream();
                os.write(bodyByte);
                InputStream stream = connection.getInputStream();
                if (stream == null) {
                    throw new Exception("Could not get an answer");
                }
                String jsonString = FileUtil.ConvertStreamToString(stream);
                connection.disconnect();
                JSONObject jsonObj = JSONUtil.parseObj((String)jsonString);
                log.info(jsonObj.toString());
                Object error = jsonObj.get((Object)"error");
                if (error != null) {
                    this.ProcessConvertServiceResponceError((Integer)error);
                }
                if ((isEndConvert = (Boolean)jsonObj.get((Object)"endConvert")).booleanValue()) {
                    resultPercent = 100L;
                    responseUri = (String)jsonObj.get((Object)"fileUrl");
                    log.info("\u6587\u4ef6\u8f6c\u5316\u5b8c\u6210{}->{}", (Object)filetype, (Object)outputtype);
                    continue;
                }
                resultPercent = jsonObj.getLong((Object)"percent");
                resultPercent = resultPercent >= 100L ? 99L : resultPercent;
            } while (async && resultPercent < 100L);
            return responseUri;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void ProcessConvertServiceResponceError(int errorCode) throws Exception {
        String errorMessage = "";
        String errorMessageTemplate = "Error occurred in the ConvertService: ";
        switch (errorCode) {
            case -8: {
                errorMessage = errorMessageTemplate + "\u4ee4\u724c\u65e0\u6548";
                break;
            }
            case -7: {
                errorMessage = errorMessageTemplate + "\u8f93\u5165\u9519\u8bef";
                break;
            }
            case -6: {
                errorMessage = errorMessageTemplate + "\u8bbf\u95ee\u8f6c\u6362\u7ed3\u679c\u6570\u636e\u5e93\u65f6\u51fa\u9519";
                break;
            }
            case -5: {
                errorMessage = errorMessageTemplate + "\u5bc6\u7801\u4e0d\u6b63\u786e";
                break;
            }
            case -4: {
                errorMessage = errorMessageTemplate + "\u4e0b\u8f7d\u8981\u8f6c\u6362\u7684\u6587\u6863\u6587\u4ef6\u65f6\u51fa\u9519";
                break;
            }
            case -3: {
                errorMessage = errorMessageTemplate + "\u8f6c\u6362\u9519\u8bef";
                break;
            }
            case -2: {
                errorMessage = errorMessageTemplate + "\u8f6c\u6362\u8d85\u65f6\u9519\u8bef";
                break;
            }
            case -1: {
                errorMessage = errorMessageTemplate + "\u672a\u77e5\u9519\u8bef";
                break;
            }
            case 0: {
                break;
            }
            default: {
                errorMessage = "ErrorCode = " + errorCode;
            }
        }
        throw new Exception(errorMessage);
    }

    private FileConfig openEditConfig(Map<String, Object> map, String mode, boolean collaborativeEditing) {
        try {
            map.put("mode", mode);
            log.info("\u5f00\u59cb\u751f\u6210\u6587\u4ef6\u4fe1\u606f");
            FileMetadata tempFileInfo = this.fileHandler.handlerFile(map, collaborativeEditing);
            log.info("\u5f00\u59cb\u751f\u6210\u7f16\u8f91\u5668\u914d\u7f6e\u4fe1\u606f");
            FileConfig fileConfigDTO = BuilderConfigInfo.buildOnlyConfig(tempFileInfo.getUrl(), mode, tempFileInfo.getKey(), tempFileInfo.getOldName(), this.configuration.getLocalhostAddress() + this.onlyProperties.getCallBackUrl(), this.onlyProperties, (FileUser)SecurityUtils.getUserSession(), this.plugins, this.getPermission(mode), this.customization);
            log.info("\u751f\u6210\u7f16\u8f91\u5668\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f");
            return fileConfigDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private DocumentPermission getPermission(String mode) {
        return this.EDIT.equals(mode) ? this.editPermission : this.viewPermission;
    }

    public CommonConfig getConfiguration() {
        return this.configuration;
    }

    public Cache getCache() {
        return this.cache;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public SaveFileProcessor getSaveFileProcessor() {
        return this.saveFileProcessor;
    }

    public OnlyProperties getOnlyProperties() {
        return this.onlyProperties;
    }

    public DocumentPermission getViewPermission() {
        return this.viewPermission;
    }

    public DocumentPermission getEditPermission() {
        return this.editPermission;
    }

    public FileCustomization getCustomization() {
        return this.customization;
    }

    public FileEmbedded getEmbedded() {
        return this.embedded;
    }

    public Plugins getPlugins() {
        return this.plugins;
    }

    public JSONObject getConvert() {
        return this.convert;
    }

    public String getEDIT() {
        return this.EDIT;
    }

    public String getVIEW() {
        return this.VIEW;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setSaveFileProcessor(SaveFileProcessor saveFileProcessor) {
        this.saveFileProcessor = saveFileProcessor;
    }

    public void setOnlyProperties(OnlyProperties onlyProperties) {
        this.onlyProperties = onlyProperties;
    }

    public void setViewPermission(DocumentPermission viewPermission) {
        this.viewPermission = viewPermission;
    }

    public void setEditPermission(DocumentPermission editPermission) {
        this.editPermission = editPermission;
    }

    public void setCustomization(FileCustomization customization) {
        this.customization = customization;
    }

    public void setEmbedded(FileEmbedded embedded) {
        this.embedded = embedded;
    }

    public void setPlugins(Plugins plugins) {
        this.plugins = plugins;
    }

    public void setConvert(JSONObject convert) {
        this.convert = convert;
    }

    public void setEDIT(String EDIT) {
        this.EDIT = EDIT;
    }

    public void setVIEW(String VIEW) {
        this.VIEW = VIEW;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOOBase)) {
            return false;
        }
        AbstractOOBase other = (AbstractOOBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonConfig this$configuration = this.getConfiguration();
        CommonConfig other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        FileHandler this$fileHandler = this.getFileHandler();
        FileHandler other$fileHandler = other.getFileHandler();
        if (this$fileHandler == null ? other$fileHandler != null : !this$fileHandler.equals(other$fileHandler)) {
            return false;
        }
        SaveFileProcessor this$saveFileProcessor = this.getSaveFileProcessor();
        SaveFileProcessor other$saveFileProcessor = other.getSaveFileProcessor();
        if (this$saveFileProcessor == null ? other$saveFileProcessor != null : !this$saveFileProcessor.equals(other$saveFileProcessor)) {
            return false;
        }
        OnlyProperties this$onlyProperties = this.getOnlyProperties();
        OnlyProperties other$onlyProperties = other.getOnlyProperties();
        if (this$onlyProperties == null ? other$onlyProperties != null : !((Object)this$onlyProperties).equals(other$onlyProperties)) {
            return false;
        }
        DocumentPermission this$viewPermission = this.getViewPermission();
        DocumentPermission other$viewPermission = other.getViewPermission();
        if (this$viewPermission == null ? other$viewPermission != null : !((Object)this$viewPermission).equals(other$viewPermission)) {
            return false;
        }
        DocumentPermission this$editPermission = this.getEditPermission();
        DocumentPermission other$editPermission = other.getEditPermission();
        if (this$editPermission == null ? other$editPermission != null : !((Object)this$editPermission).equals(other$editPermission)) {
            return false;
        }
        FileCustomization this$customization = this.getCustomization();
        FileCustomization other$customization = other.getCustomization();
        if (this$customization == null ? other$customization != null : !((Object)this$customization).equals(other$customization)) {
            return false;
        }
        FileEmbedded this$embedded = this.getEmbedded();
        FileEmbedded other$embedded = other.getEmbedded();
        if (this$embedded == null ? other$embedded != null : !((Object)this$embedded).equals(other$embedded)) {
            return false;
        }
        Plugins this$plugins = this.getPlugins();
        Plugins other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        JSONObject this$convert = this.getConvert();
        JSONObject other$convert = other.getConvert();
        if (this$convert == null ? other$convert != null : !this$convert.equals(other$convert)) {
            return false;
        }
        String this$EDIT = this.getEDIT();
        String other$EDIT = other.getEDIT();
        if (this$EDIT == null ? other$EDIT != null : !this$EDIT.equals(other$EDIT)) {
            return false;
        }
        String this$VIEW = this.getVIEW();
        String other$VIEW = other.getVIEW();
        return !(this$VIEW == null ? other$VIEW != null : !this$VIEW.equals(other$VIEW));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractOOBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        FileHandler $fileHandler = this.getFileHandler();
        result = result * 59 + ($fileHandler == null ? 43 : $fileHandler.hashCode());
        SaveFileProcessor $saveFileProcessor = this.getSaveFileProcessor();
        result = result * 59 + ($saveFileProcessor == null ? 43 : $saveFileProcessor.hashCode());
        OnlyProperties $onlyProperties = this.getOnlyProperties();
        result = result * 59 + ($onlyProperties == null ? 43 : ((Object)$onlyProperties).hashCode());
        DocumentPermission $viewPermission = this.getViewPermission();
        result = result * 59 + ($viewPermission == null ? 43 : ((Object)$viewPermission).hashCode());
        DocumentPermission $editPermission = this.getEditPermission();
        result = result * 59 + ($editPermission == null ? 43 : ((Object)$editPermission).hashCode());
        FileCustomization $customization = this.getCustomization();
        result = result * 59 + ($customization == null ? 43 : ((Object)$customization).hashCode());
        FileEmbedded $embedded = this.getEmbedded();
        result = result * 59 + ($embedded == null ? 43 : ((Object)$embedded).hashCode());
        Plugins $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        JSONObject $convert = this.getConvert();
        result = result * 59 + ($convert == null ? 43 : $convert.hashCode());
        String $EDIT = this.getEDIT();
        result = result * 59 + ($EDIT == null ? 43 : $EDIT.hashCode());
        String $VIEW = this.getVIEW();
        result = result * 59 + ($VIEW == null ? 43 : $VIEW.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractOOBase(configuration=" + this.getConfiguration() + ", cache=" + this.getCache() + ", fileHandler=" + this.getFileHandler() + ", saveFileProcessor=" + this.getSaveFileProcessor() + ", onlyProperties=" + this.getOnlyProperties() + ", viewPermission=" + this.getViewPermission() + ", editPermission=" + this.getEditPermission() + ", customization=" + this.getCustomization() + ", embedded=" + this.getEmbedded() + ", plugins=" + this.getPlugins() + ", convert=" + this.getConvert() + ", EDIT=" + this.getEDIT() + ", VIEW=" + this.getVIEW() + ")";
    }
}

