/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.antlr.XpathBaseVisitor;
import org.seimicrawler.xpath.antlr.XpathParser;
import org.seimicrawler.xpath.core.AxisSelector;
import org.seimicrawler.xpath.core.Function;
import org.seimicrawler.xpath.core.NodeTest;
import org.seimicrawler.xpath.core.Scope;
import org.seimicrawler.xpath.core.XValue;
import org.seimicrawler.xpath.exception.XpathMergeValueException;
import org.seimicrawler.xpath.exception.XpathParserException;
import org.seimicrawler.xpath.util.CommonUtil;
import org.seimicrawler.xpath.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpathProcessor
extends XpathBaseVisitor<XValue> {
    private Logger logger = LoggerFactory.getLogger(XpathProcessor.class);
    private Stack<Scope> scopeStack = new Stack();
    private Scope rootScope;

    public XpathProcessor(Elements root) {
        this.rootScope = Scope.create(root);
        this.scopeStack.push(Scope.create(root).setParent(this.rootScope));
    }

    @Override
    public XValue visitMain(XpathParser.MainContext ctx) {
        return (XValue)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public XValue visitLocationPath(XpathParser.LocationPathContext ctx) {
        if (ctx.relativeLocationPath() != null && !ctx.relativeLocationPath().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.relativeLocationPath());
        }
        return (XValue)this.visit((ParseTree)ctx.absoluteLocationPathNoroot());
    }

    @Override
    public XValue visitAbsoluteLocationPathNoroot(XpathParser.AbsoluteLocationPathNorootContext ctx) {
        this.scopeStack.push(Scope.create(this.rootScope.context()).setParent(this.currentScope()));
        if (Objects.equals(ctx.op.getText(), "//")) {
            this.currentScope().recursion();
        }
        XValue value = (XValue)this.visit((ParseTree)ctx.relativeLocationPath());
        this.scopeStack.pop();
        return value;
    }

    @Override
    public XValue visitRelativeLocationPath(XpathParser.RelativeLocationPathContext ctx) {
        XValue finalVal = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree step = ctx.getChild(i);
            if (step instanceof XpathParser.StepContext) {
                finalVal = (XValue)this.visit(step);
                if (!finalVal.isElements()) continue;
                this.updateCurrentContext(finalVal.asElements());
                continue;
            }
            if ("//".equals(step.getText())) {
                this.currentScope().recursion();
                continue;
            }
            this.currentScope().notRecursion();
        }
        return finalVal;
    }

    @Override
    public XValue visitStep(XpathParser.StepContext ctx) {
        XValue axis;
        if (ctx.abbreviatedStep() != null && !ctx.abbreviatedStep().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.abbreviatedStep());
        }
        boolean filterByAttr = false;
        boolean isAxisOk = false;
        if (ctx.axisSpecifier() != null && !ctx.axisSpecifier().isEmpty() && (axis = (XValue)this.visit((ParseTree)ctx.axisSpecifier())) != null) {
            isAxisOk = true;
            if (axis.isElements()) {
                this.updateCurrentContext(axis.asElements());
            } else if (axis.isAttr()) {
                filterByAttr = true;
            }
        }
        if (ctx.nodeTest() != null && !ctx.nodeTest().isEmpty()) {
            XValue nodeTest = (XValue)this.visit((ParseTree)ctx.nodeTest());
            if (filterByAttr) {
                Elements context = this.currentScope().context();
                String attrName = nodeTest.asString();
                if (this.currentScope().isRecursion()) {
                    if (context.size() == 1) {
                        Element el = this.currentScope().singleEl();
                        Elements findRes = el.select("[" + attrName + "]");
                        LinkedList<String> attrs = new LinkedList<String>();
                        for (Element e : findRes) {
                            attrs.add(e.attr(attrName));
                        }
                        return XValue.create(attrs);
                    }
                    Elements findRes = new Elements();
                    for (Object el : context) {
                        findRes.addAll((Collection)el.select("[" + attrName + "]"));
                    }
                    LinkedList<String> attrs = new LinkedList<String>();
                    for (Element e : findRes) {
                        attrs.add(e.attr(attrName));
                    }
                    return XValue.create(attrs);
                }
                if (context.size() == 1) {
                    Element el = this.currentScope().singleEl();
                    return XValue.create(el.attr(attrName));
                }
                LinkedList<String> attrs = new LinkedList<String>();
                for (Element el : context) {
                    attrs.add(el.attr(attrName));
                }
                return XValue.create(attrs);
            }
            if (nodeTest.isExprStr()) {
                String tagName = nodeTest.asString();
                Elements current = this.currentScope().context();
                if (this.currentScope().isRecursion()) {
                    this.updateCurrentContext(current.select(tagName));
                } else {
                    Elements newContext = new Elements();
                    for (Element el : this.currentScope().context()) {
                        if (isAxisOk) {
                            if (!el.nodeName().equals(tagName) && !"*".equals(tagName)) continue;
                            newContext.add((Object)el);
                            continue;
                        }
                        for (Element e : el.children()) {
                            if (!e.nodeName().equals(tagName) && !"*".equals(tagName)) continue;
                            newContext.add((Object)e);
                        }
                    }
                    this.updateCurrentContext(newContext);
                }
            } else if (nodeTest.isElements()) {
                this.updateCurrentContext(nodeTest.asElements());
            } else {
                return nodeTest;
            }
        }
        if (ctx.predicate() != null && ctx.predicate().size() > 0) {
            for (XpathParser.PredicateContext predicate : ctx.predicate()) {
                XValue predicateVal = (XValue)this.visit((ParseTree)predicate);
                this.updateCurrentContext(predicateVal.asElements());
            }
        }
        return XValue.create(this.currentScope().context());
    }

    @Override
    public XValue visitAbbreviatedStep(XpathParser.AbbreviatedStepContext ctx) {
        if ("..".equals(ctx.getText())) {
            HashSet<Element> total = new HashSet<Element>();
            Elements newContext = new Elements();
            for (Element e : this.currentScope().context()) {
                total.add(e.parent());
            }
            newContext.addAll(total);
            return XValue.create(newContext);
        }
        return XValue.create(this.currentScope().context());
    }

    @Override
    public XValue visitAxisSpecifier(XpathParser.AxisSpecifierContext ctx) {
        TerminalNode axisNode = ctx.AxisName();
        if (axisNode != null) {
            String axis = ctx.AxisName().getText();
            AxisSelector axisSelector = Scanner.findSelectorByName(axis);
            return axisSelector.apply(this.currentScope().context());
        }
        String token = ctx.getText();
        if ("@".equals(token)) {
            return XValue.create(null).attr();
        }
        return null;
    }

    @Override
    public XValue visitNodeTest(XpathParser.NodeTestContext ctx) {
        if (ctx.nameTest() != null) {
            return (XValue)this.visit((ParseTree)ctx.nameTest());
        }
        if (ctx.NodeType() != null) {
            NodeTest nodeTest = Scanner.findNodeTestByName(ctx.NodeType().getText());
            return nodeTest.call(this.currentScope());
        }
        return null;
    }

    @Override
    public XValue visitPredicate(XpathParser.PredicateContext ctx) {
        Elements newContext = new Elements();
        for (Element e : this.currentScope().context()) {
            this.scopeStack.push(Scope.create(e).setParent(this.currentScope()));
            XValue exprVal = (XValue)this.visit((ParseTree)ctx.expr());
            this.scopeStack.pop();
            if (exprVal.isNumber()) {
                long index = exprVal.asLong();
                if (index < 0L && (index = Objects.equals(e.tagName(), "JX_TEXT") ? (long)CommonUtil.getJxSameTagNumsInSiblings(e) + index + 1L : (long)CommonUtil.sameTagElNums(e, this.currentScope()) + index + 1L) < 0L) {
                    index = 1L;
                }
                if (Objects.equals(e.tagName(), "JX_TEXT")) {
                    if (index != (long)CommonUtil.getJxSameTagIndexInSiblings(e)) continue;
                    newContext.add((Object)e);
                    continue;
                }
                if (index != (long)CommonUtil.getElIndexInSameTags(e, this.currentScope())) continue;
                newContext.add((Object)e);
                continue;
            }
            if (exprVal.isBoolean()) {
                if (!exprVal.asBoolean().booleanValue()) continue;
                newContext.add((Object)e);
                continue;
            }
            if (exprVal.isString()) {
                if (!StringUtils.isNotBlank((CharSequence)exprVal.asString())) continue;
                newContext.add((Object)e);
                continue;
            }
            if (exprVal.isElements()) {
                Elements els = exprVal.asElements();
                if (els.size() <= 0) continue;
                newContext.add((Object)e);
                continue;
            }
            if (exprVal.isList()) {
                List<String> stringList = exprVal.asList();
                if (stringList.size() <= 0) continue;
                newContext.add((Object)e);
                continue;
            }
            throw new XpathParserException("unknown expr val:" + exprVal);
        }
        return XValue.create(newContext);
    }

    @Override
    public XValue visitNameTest(XpathParser.NameTestContext ctx) {
        if ("*".equals(ctx.getText())) {
            return XValue.create("*").exprStr();
        }
        if (ctx.qName() != null && !ctx.qName().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.qName());
        }
        if (ctx.nCName() != null && !ctx.nCName().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.nCName());
        }
        return null;
    }

    @Override
    public XValue visitQName(XpathParser.QNameContext ctx) {
        List<XpathParser.NCNameContext> ncNameContexts = ctx.nCName();
        if (ncNameContexts != null) {
            if (ncNameContexts.size() > 1) {
                LinkedList<String> ncNames = new LinkedList<String>();
                for (XpathParser.NCNameContext ncNameContext : ncNameContexts) {
                    XValue value = (XValue)this.visit((ParseTree)ncNameContext);
                    if (value == null) continue;
                    ncNames.add(value.asString());
                }
                return XValue.create(StringUtils.join(ncNames, (String)":"));
            }
            return (XValue)this.visit((ParseTree)ncNameContexts.get(0));
        }
        return null;
    }

    @Override
    public XValue visitNCName(XpathParser.NCNameContext ctx) {
        if (ctx.AxisName() != null) {
            return XValue.create(ctx.AxisName().getText()).exprStr();
        }
        return XValue.create(ctx.NCName().getText()).exprStr();
    }

    @Override
    public XValue visitExpr(XpathParser.ExprContext ctx) {
        return (XValue)this.visit((ParseTree)ctx.orExpr());
    }

    @Override
    public XValue visitOrExpr(XpathParser.OrExprContext ctx) {
        List<XpathParser.AndExprContext> andExprContexts = ctx.andExpr();
        if (andExprContexts.size() > 1) {
            Boolean res = ((XValue)this.visit((ParseTree)andExprContexts.get(0))).asBoolean();
            for (int i = 1; i < andExprContexts.size(); ++i) {
                res = res | ((XValue)this.visit((ParseTree)andExprContexts.get(i))).asBoolean();
            }
            return XValue.create(res);
        }
        return (XValue)this.visit((ParseTree)andExprContexts.get(0));
    }

    @Override
    public XValue visitAndExpr(XpathParser.AndExprContext ctx) {
        List<XpathParser.EqualityExprContext> equalityExprContexts = ctx.equalityExpr();
        if (equalityExprContexts.size() > 1) {
            Boolean res = ((XValue)this.visit((ParseTree)equalityExprContexts.get(0))).asBoolean();
            for (int i = 1; i < equalityExprContexts.size(); ++i) {
                res = res & ((XValue)this.visit((ParseTree)equalityExprContexts.get(i))).asBoolean();
            }
            return XValue.create(res);
        }
        return (XValue)this.visit((ParseTree)equalityExprContexts.get(0));
    }

    @Override
    public XValue visitEqualityExpr(XpathParser.EqualityExprContext ctx) {
        List<XpathParser.RelationalExprContext> relationalExprContexts = ctx.relationalExpr();
        if (relationalExprContexts.size() == 1) {
            return (XValue)this.visit((ParseTree)relationalExprContexts.get(0));
        }
        if (relationalExprContexts.size() == 2) {
            XValue left = (XValue)this.visit((ParseTree)relationalExprContexts.get(0));
            XValue right = (XValue)this.visit((ParseTree)relationalExprContexts.get(1));
            if ("=".equals(ctx.op.getText())) {
                if (left.valType().equals(right.valType())) {
                    return XValue.create(Objects.equals(left, right));
                }
                return XValue.create(Objects.equals(left.asString(), right.asString()));
            }
            if (left.valType().equals(right.valType())) {
                return XValue.create(!Objects.equals(left, right));
            }
            return XValue.create(!Objects.equals(left.asString(), right.asString()));
        }
        throw new XpathParserException("error equalityExpr near:" + ctx.getText());
    }

    @Override
    public XValue visitRelationalExpr(XpathParser.RelationalExprContext ctx) {
        List<XpathParser.AdditiveExprContext> additiveExprContexts = ctx.additiveExpr();
        if (additiveExprContexts.size() == 1) {
            return (XValue)this.visit((ParseTree)additiveExprContexts.get(0));
        }
        if (additiveExprContexts.size() == 2) {
            XValue left = (XValue)this.visit((ParseTree)additiveExprContexts.get(0));
            XValue right = (XValue)this.visit((ParseTree)additiveExprContexts.get(1));
            switch (ctx.op.getType()) {
                case 25: {
                    return XValue.create(left.compareTo(right) > 0);
                }
                case 27: {
                    return XValue.create(left.compareTo(right) >= 0);
                }
                case 24: {
                    return XValue.create(left.compareTo(right) < 0);
                }
                case 26: {
                    return XValue.create(left.compareTo(right) <= 0);
                }
                case 30: {
                    return XValue.create(left.asString().startsWith(right.asString()));
                }
                case 31: {
                    return XValue.create(left.asString().endsWith(right.asString()));
                }
                case 32: {
                    return XValue.create(left.asString().contains(right.asString()));
                }
                case 33: {
                    return XValue.create(left.asString().matches(right.asString()));
                }
                case 34: {
                    return XValue.create(!left.asString().matches(right.asString()));
                }
            }
            throw new XpathParserException("unknown operator" + ctx.op.getText());
        }
        throw new XpathParserException("error equalityExpr near:" + ctx.getText());
    }

    @Override
    public XValue visitAdditiveExpr(XpathParser.AdditiveExprContext ctx) {
        List<XpathParser.MultiplicativeExprContext> multiplicativeExprContexts = ctx.multiplicativeExpr();
        if (multiplicativeExprContexts.size() == 1) {
            return (XValue)this.visit((ParseTree)multiplicativeExprContexts.get(0));
        }
        Double res = ((XValue)this.visit((ParseTree)multiplicativeExprContexts.get(0))).asDouble();
        String op = null;
        for (int i = 1; i < ctx.getChildCount(); ++i) {
            ParseTree chiCtx = ctx.getChild(i);
            if (chiCtx instanceof XpathParser.MultiplicativeExprContext) {
                XValue next = (XValue)this.visit(chiCtx);
                if ("+".equals(op)) {
                    res = res + next.asDouble();
                    continue;
                }
                if ("-".equals(op)) {
                    res = res - next.asDouble();
                    continue;
                }
                throw new XpathParserException("syntax error, " + ctx.getText());
            }
            op = chiCtx.getText();
        }
        return XValue.create(res);
    }

    @Override
    public XValue visitMultiplicativeExpr(XpathParser.MultiplicativeExprContext ctx) {
        if (ctx.multiplicativeExpr() == null || ctx.multiplicativeExpr().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.unaryExprNoRoot());
        }
        XValue left = (XValue)this.visit((ParseTree)ctx.unaryExprNoRoot());
        XValue right = (XValue)this.visit((ParseTree)ctx.multiplicativeExpr());
        switch (ctx.op.getType()) {
            case 17: {
                return XValue.create(left.asDouble() * right.asDouble());
            }
            case 18: {
                return XValue.create(left.asDouble() / right.asDouble());
            }
            case 19: {
                return XValue.create(left.asDouble() % right.asDouble());
            }
        }
        throw new XpathParserException("syntax error, " + ctx.getText());
    }

    @Override
    public XValue visitUnaryExprNoRoot(XpathParser.UnaryExprNoRootContext ctx) {
        XValue value = (XValue)this.visit((ParseTree)ctx.unionExprNoRoot());
        if (ctx.sign == null) {
            return value;
        }
        return XValue.create(-value.asDouble().doubleValue());
    }

    @Override
    public XValue visitUnionExprNoRoot(XpathParser.UnionExprNoRootContext ctx) {
        if (ctx.pathExprNoRoot() == null && !ctx.pathExprNoRoot().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.unionExprNoRoot());
        }
        XValue pathExprNoRoot = (XValue)this.visit((ParseTree)ctx.pathExprNoRoot());
        if (ctx.op == null) {
            return pathExprNoRoot;
        }
        this.scopeStack.push(Scope.create(this.currentScope().getParent()));
        XValue unionExprNoRoot = (XValue)this.visit((ParseTree)ctx.unionExprNoRoot());
        this.scopeStack.pop();
        if (pathExprNoRoot.isElements()) {
            if (unionExprNoRoot.isElements()) {
                pathExprNoRoot.asElements().addAll((Collection)unionExprNoRoot.asElements());
            } else {
                Element element = new Element("V");
                element.appendText(unionExprNoRoot.asString());
                pathExprNoRoot.asElements().add((Object)element);
            }
            return pathExprNoRoot;
        }
        if (pathExprNoRoot.isString()) {
            if (unionExprNoRoot.isElements()) {
                Element element = new Element("V");
                element.appendText(pathExprNoRoot.asString());
                unionExprNoRoot.asElements().add((Object)element);
                return unionExprNoRoot;
            }
            return XValue.create(pathExprNoRoot.asString() + unionExprNoRoot.asString());
        }
        if (pathExprNoRoot.isBoolean()) {
            if (unionExprNoRoot.isBoolean()) {
                return XValue.create(pathExprNoRoot.asBoolean() | unionExprNoRoot.asBoolean());
            }
            if (unionExprNoRoot.isElements()) {
                Element element = new Element("V");
                element.appendText(pathExprNoRoot.asString());
                unionExprNoRoot.asElements().add((Object)element);
                return unionExprNoRoot;
            }
            if (unionExprNoRoot.isString()) {
                return XValue.create(pathExprNoRoot.asBoolean() + unionExprNoRoot.asString());
            }
            throw new XpathMergeValueException("can not merge val1=" + pathExprNoRoot.asBoolean() + ",val2=" + unionExprNoRoot.asString());
        }
        if (pathExprNoRoot.isNumber()) {
            if (unionExprNoRoot.isString()) {
                return XValue.create(pathExprNoRoot.asDouble() + unionExprNoRoot.asString());
            }
            if (unionExprNoRoot.isElements()) {
                Element element = new Element("V");
                element.appendText(pathExprNoRoot.asString());
                unionExprNoRoot.asElements().add((Object)element);
                return unionExprNoRoot;
            }
            throw new XpathMergeValueException("can not merge val1=" + pathExprNoRoot.asDouble() + ",val2=" + unionExprNoRoot.asString());
        }
        LinkedList<String> tmpVal = new LinkedList<String>();
        if (StringUtils.isNotBlank((CharSequence)pathExprNoRoot.asString())) {
            tmpVal.add(pathExprNoRoot.asString());
        }
        if (StringUtils.isNotBlank((CharSequence)unionExprNoRoot.asString())) {
            tmpVal.add(unionExprNoRoot.asString());
        }
        return XValue.create(StringUtils.join(tmpVal, (String)","));
    }

    @Override
    public XValue visitPathExprNoRoot(XpathParser.PathExprNoRootContext ctx) {
        if (ctx.locationPath() != null && !ctx.locationPath().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.locationPath());
        }
        if (ctx.op == null) {
            return (XValue)this.visit((ParseTree)ctx.filterExpr());
        }
        if ("//".equals(ctx.op.getText())) {
            this.currentScope().recursion();
        }
        return (XValue)this.visit((ParseTree)ctx.relativeLocationPath());
    }

    @Override
    public XValue visitFilterExpr(XpathParser.FilterExprContext ctx) {
        return (XValue)this.visit((ParseTree)ctx.primaryExpr());
    }

    @Override
    public XValue visitPrimaryExpr(XpathParser.PrimaryExprContext ctx) {
        if (ctx.expr() != null && !ctx.expr().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.expr());
        }
        if (ctx.functionCall() != null && !ctx.functionCall().isEmpty()) {
            return (XValue)this.visit((ParseTree)ctx.functionCall());
        }
        if (ctx.Literal() != null) {
            return XValue.create(ctx.Literal().getText()).exprStr();
        }
        if (ctx.Number() != null) {
            return XValue.create(NumberUtils.createDouble((String)ctx.Number().getText()));
        }
        throw new XpathParserException("not support variableReference:" + ctx.getText());
    }

    @Override
    public XValue visitFunctionCall(XpathParser.FunctionCallContext ctx) {
        LinkedList<XValue> params = new LinkedList<XValue>();
        XValue funcName = (XValue)this.visit((ParseTree)ctx.functionName());
        for (XpathParser.ExprContext exprContext : ctx.expr()) {
            this.scopeStack.push(Scope.create(this.currentScope()));
            params.add((XValue)this.visit((ParseTree)exprContext));
            this.scopeStack.pop();
        }
        Function function = Scanner.findFunctionByName(funcName.asString());
        return function.call(this.currentScope(), params);
    }

    @Override
    public XValue visitFunctionName(XpathParser.FunctionNameContext ctx) {
        return (XValue)this.visit((ParseTree)ctx.qName());
    }

    private Scope currentScope() {
        return this.scopeStack.peek();
    }

    private void updateCurrentContext(Elements newContext) {
        this.scopeStack.peek().setContext(newContext);
    }
}

