/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.loginlog.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.log.api.pojo.loginlog.SysLoginLogDto;
import cn.stylefeng.roses.kernel.log.api.pojo.loginlog.SysLoginLogRequest;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.enums.log.LogExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.modular.loginlog.entity.SysLoginLog;
import cn.stylefeng.roses.kernel.system.modular.loginlog.mapper.SysLoginLogMapper;
import cn.stylefeng.roses.kernel.system.modular.loginlog.service.SysLoginLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class SysLoginLogServiceImpl
extends ServiceImpl<SysLoginLogMapper, SysLoginLog>
implements SysLoginLogService,
LoginLogServiceApi {
    @Resource
    private UserServiceApi userServiceApi;

    @Override
    public void del(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = this.querySysLoginLogById(sysLoginLogRequest);
        this.removeById(sysLoginLog.getLlgId());
    }

    @Override
    public SysLoginLog detail(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper<SysLoginLog> queryWrapper = this.createWrapper(sysLoginLogRequest);
        return (SysLoginLog)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    public PageResult<SysLoginLogDto> findPage(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper<SysLoginLog> wrapper = this.createWrapper(sysLoginLogRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        ArrayList<SysLoginLogDto> sysLoginLogDtos = new ArrayList<SysLoginLogDto>();
        for (SysLoginLog record : page.getRecords()) {
            SysLoginLogDto sysLoginLogDto = new SysLoginLogDto();
            BeanUtil.copyProperties((Object)record, (Object)sysLoginLogDto, (String[])new String[0]);
            SysUserDTO userInfoByUserId = this.userServiceApi.getUserInfoByUserId(sysLoginLogDto.getUserId());
            if (userInfoByUserId != null) {
                sysLoginLogDto.setUserName(userInfoByUserId.getRealName());
            }
            sysLoginLogDtos.add(sysLoginLogDto);
        }
        return PageResultFactory.createPageResult(sysLoginLogDtos, (Long)page.getTotal(), (Integer)Convert.toInt((Object)page.getSize()), (Integer)Convert.toInt((Object)page.getCurrent()));
    }

    public void add(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        BeanUtil.copyProperties((Object)sysLoginLogRequest, (Object)sysLoginLog, (String[])new String[0]);
        this.save(sysLoginLog);
    }

    public void loginSuccess(Long userId) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u767b\u5f55\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u6210\u529f");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u767b\u5f55\u6210\u529f\uff01");
        this.save(sysLoginLog);
    }

    public void loginFail(Long userId, String llgMessage) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u767b\u5f55\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u5931\u8d25");
        sysLoginLog.setLlgMessage(llgMessage);
        this.save(sysLoginLog);
    }

    public void loginOutSuccess(Long userId) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u9000\u51fa\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u6210\u529f");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u9000\u51fa\u6210\u529f\uff01");
        this.save(sysLoginLog);
    }

    public void loginOutFail(Long userId) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u9000\u51fa\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u5931\u8d25");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u9000\u51fa\u5931\u8d25\uff01");
        this.save(sysLoginLog);
    }

    @Override
    public void delAll() {
        this.remove(null);
    }

    private SysLoginLog querySysLoginLogById(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = (SysLoginLog)this.getById(sysLoginLogRequest.getLlgId());
        if (ObjectUtil.isNull((Object)sysLoginLog)) {
            throw new ServiceException((AbstractExceptionEnum)LogExceptionEnum.LOG_NOT_EXIST);
        }
        return sysLoginLog;
    }

    private LambdaQueryWrapper<SysLoginLog> createWrapper(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isEmpty((Object)sysLoginLogRequest)) {
            return queryWrapper;
        }
        Date beginDate = null;
        if (StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getBeginTime())) {
            beginDate = DateUtil.parseDateTime((CharSequence)(sysLoginLogRequest.getBeginTime() + " 00:00:00")).toJdkDate();
        }
        Date endDate = null;
        if (StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getEndTime())) {
            endDate = DateUtil.parseDateTime((CharSequence)(sysLoginLogRequest.getEndTime() + " 23:59:59")).toJdkDate();
        }
        queryWrapper.eq(StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getLlgName()), SysLoginLog::getLlgName, (Object)sysLoginLogRequest.getLlgName());
        queryWrapper.ge(StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getBeginTime()), SysLoginLog::getCreateTime, (Object)beginDate);
        queryWrapper.le(StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getEndTime()), SysLoginLog::getCreateTime, (Object)endDate);
        queryWrapper.orderByDesc(SysLoginLog::getCreateTime);
        return queryWrapper;
    }
}

