/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.kafka.error.deadLetter;

import cn.org.faster.framework.kafka.error.log.KafkaLoggingErrorHandler;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;

public class KafkaDeadLetterErrorHandler
implements ErrorHandler,
KafkaLoggingErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(KafkaDeadLetterErrorHandler.class);
    private final DeadLetterPublishingRecoverer deadLetterPublishingRecoverer;

    public KafkaDeadLetterErrorHandler(KafkaTemplate<Object, Object> kafkaTemplate) {
        this.deadLetterPublishingRecoverer = new DeadLetterPublishingRecoverer(kafkaTemplate);
    }

    public void handle(Exception thrownException, ConsumerRecord<?, ?> data) {
        thrownException.printStackTrace();
        log.error(this.handleLogMessage(thrownException));
        if (thrownException.getCause() instanceof MethodArgumentNotValidException) {
            return;
        }
        log.error("send failed message to dead letter");
        this.deadLetterPublishingRecoverer.accept(data, thrownException);
        log.error("send failed message to dead letter successful");
    }
}

