/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.ColumnInfo;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.DataBaseException;
import cn.langpy.kotime.util.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataBaseUtil {
    private static Logger log = Logger.getLogger(DataBaseUtil.class.toString());
    private static Map<String, ColumnInfo> tableInfoMap = new ConcurrentHashMap<String, ColumnInfo>();
    private static Map<String, List<ColumnInfo>> sqlColumns = new ConcurrentHashMap<String, List<ColumnInfo>>();

    public static DataSource getDataSource() {
        return Context.getDataSource();
    }

    public static int insert(String sql, Object[] values) {
        try {
            Connection connection = DataBaseUtil.getDataSource().getConnection();
            return DataBaseUtil.insert(connection, sql, values);
        }
        catch (SQLException e) {
            if (e.getClass().getSimpleName().equals("CommunicationsException") || e.getClass().getSimpleName().equals("MySQLTimeoutException")) {
                log.severe("Failure database connection!");
            } else {
                log.severe("Error insert:" + sql);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insert(Connection connection, String sql, Object[] values) {
        PreparedStatement statement = null;
        try {
            int n;
            statement = connection.prepareStatement(sql);
            if (null != values) {
                statement = DataBaseUtil.setParams(statement, values);
            }
            int n2 = n = statement.executeUpdate();
            return n2;
        }
        catch (SQLIntegrityConstraintViolationException n) {
        }
        catch (SQLException e) {
            if (e.getClass().getSimpleName().equals("CommunicationsException") || e.getClass().getSimpleName().equals("MySQLTimeoutException")) {
                log.severe("Failure database connection!");
            } else {
                log.severe("Error insert:" + sql);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int truncateByTable(Connection connection, String table) {
        PreparedStatement statement = null;
        try {
            int n;
            statement = connection.prepareStatement("truncate table " + table);
            int n2 = n = statement.executeUpdate();
            return n2;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return 0;
    }

    public static int update(String sql, Object[] values) {
        int n;
        block10: {
            Connection connection = DataBaseUtil.getDataSource().getConnection();
            try {
                n = DataBaseUtil.update(connection, sql, values);
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (e.getClass().getSimpleName().equals("CommunicationsException") || e.getClass().getSimpleName().equals("MySQLTimeoutException")) {
                        log.severe("Failure database connection!");
                    } else {
                        log.severe("Error update:" + sql);
                    }
                    return 0;
                }
            }
            connection.close();
        }
        return n;
    }

    public static int update(Connection connection, String sql, Object[] values) {
        return DataBaseUtil.insert(connection, sql, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> query(Connection connection, String sql, Object[] values) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql);
            if (null != values) {
                statement = DataBaseUtil.setParams(statement, values);
            }
            statement.setQueryTimeout(15);
            resultSet = statement.executeQuery();
            List<ColumnInfo> columns = null;
            if (sqlColumns.containsKey(sql)) {
                columns = sqlColumns.get(sql);
            } else {
                ResultSetMetaData metaData = statement.getMetaData();
                columns = DataBaseUtil.getColumns(metaData);
                sqlColumns.put(sql, columns);
            }
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (ColumnInfo column : columns) {
                    map.put(column.getName(), DataBaseUtil.getColumnValue(resultSet, column));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            log.severe("Error query for database");
            if (e.getClass().getSimpleName().equals("CommunicationsException") || e.getClass().getSimpleName().equals("MySQLTimeoutException")) {
                connection = null;
                log.severe("Failure database connection!");
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsById(Connection connection, String sql, Object id) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql);
            statement = DataBaseUtil.setParams(statement, id);
            statement.setQueryTimeout(15);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            connection = null;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> query(Connection connection, String sql, Object[] values, Class<T> c) {
        ArrayList<T> list = new ArrayList<T>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql);
            if (null != values) {
                statement = DataBaseUtil.setParams(statement, values);
            }
            statement.setQueryTimeout(15);
            resultSet = statement.executeQuery();
            List<ColumnInfo> columns = null;
            if (sqlColumns.containsKey(sql)) {
                columns = sqlColumns.get(sql);
            } else {
                ResultSetMetaData metaData = statement.getMetaData();
                resultSet = statement.executeQuery();
                columns = DataBaseUtil.getColumns(metaData);
                sqlColumns.put(sql, columns);
            }
            Field[] fields = null;
            while (resultSet.next()) {
                T object = c.newInstance();
                if (null == fields) {
                    fields = object.getClass().getDeclaredFields();
                }
                for (Field field : fields) {
                    int mod = field.getModifiers();
                    if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                    ColumnInfo column = null;
                    if (tableInfoMap.containsKey(columns.get(0).getTable() + field.getName())) {
                        column = tableInfoMap.get(columns.get(0).getTable() + field.getName());
                    } else {
                        column = DataBaseUtil.matchColumn(field, columns);
                        if (null == column) continue;
                        tableInfoMap.put(column.getTable() + field.getName(), column);
                    }
                    field.setAccessible(true);
                    Object columnValue = DataBaseUtil.getColumnValue(resultSet, column);
                    if (field.getName().equals("methodType")) {
                        field.set(object, (Object)MethodType.valueOf("" + columnValue));
                    } else {
                        field.set(object, columnValue);
                    }
                    field.setAccessible(false);
                }
                list.add(object);
            }
        }
        catch (SQLException e) {
            log.severe("Error query for database!");
            if (e.getClass().getSimpleName().equals("CommunicationsException") || e.getClass().getSimpleName().equals("MySQLTimeoutException")) {
                connection = null;
                log.severe("Failure database connection!");
            }
        }
        catch (IllegalAccessException e) {
            log.severe("Error access for database!");
        }
        catch (InstantiationException e) {
            log.severe("Error instance for database!");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return list;
    }

    public static <T> List<T> query(String sql, Object[] values, Class<T> c) {
        List<Object> list = null;
        try (Connection connection = DataBaseUtil.getDataSource().getConnection();){
            list = DataBaseUtil.query(connection, sql, values, c);
        }
        catch (SQLException throwables) {
            list = new ArrayList();
        }
        return list;
    }

    public static ColumnInfo matchColumn(Field field, List<ColumnInfo> columns) {
        for (ColumnInfo column : columns) {
            String columnReplace = column.getName().replace("_", "");
            if (!field.getName().equalsIgnoreCase(columnReplace)) continue;
            return column;
        }
        return null;
    }

    private static PreparedStatement setParams(PreparedStatement statement, Object[] values) {
        try {
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                if (values[i] == null) {
                    statement.setObject(i + 1, null);
                    continue;
                }
                if (values[i] instanceof String) {
                    statement.setString(i + 1, (String)values[i]);
                    continue;
                }
                if (values[i] instanceof Double) {
                    statement.setDouble(i + 1, (Double)values[i]);
                    continue;
                }
                if (values[i] instanceof Integer) {
                    statement.setInt(i + 1, (Integer)values[i]);
                    continue;
                }
                if (values[i] instanceof Boolean) {
                    statement.setBoolean(i + 1, (Boolean)values[i]);
                    continue;
                }
                throw new DataBaseException("Invalid type=" + values[i].getClass().getName());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return statement;
    }

    private static PreparedStatement setParams(PreparedStatement statement, Object value) {
        block7: {
            try {
                if (value == null) {
                    statement.setObject(1, null);
                    break block7;
                }
                if (value instanceof String) {
                    statement.setString(1, (String)value);
                    break block7;
                }
                if (value instanceof Double) {
                    statement.setDouble(1, (Double)value);
                    break block7;
                }
                if (value instanceof Integer) {
                    statement.setInt(1, (Integer)value);
                    break block7;
                }
                if (value instanceof Boolean) {
                    statement.setBoolean(1, (Boolean)value);
                    break block7;
                }
                throw new DataBaseException("Invalid type=" + value.getClass().getName());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return statement;
    }

    private static Object getColumnValue(ResultSet resultSet, ColumnInfo column) throws SQLException {
        if ("VARCHAR".equals(column.getDataType()) || "TEXT".equals(column.getDataType())) {
            return resultSet.getString(column.getName());
        }
        if ("DECIMAL".equalsIgnoreCase(column.getDataType())) {
            return resultSet.getBigDecimal(column.getName()).doubleValue();
        }
        if ("DOUBLE".equalsIgnoreCase(column.getDataType())) {
            return resultSet.getDouble(column.getName());
        }
        if ("INT".equalsIgnoreCase(column.getDataType())) {
            return resultSet.getInt(column.getName());
        }
        if ("DATETIME".equalsIgnoreCase(column.getDataType())) {
            return resultSet.getTimestamp(column.getName());
        }
        return resultSet.getObject(column.getName());
    }

    private static List<ColumnInfo> getColumns(ResultSetMetaData metaData) throws SQLException {
        ArrayList<ColumnInfo> colnames = new ArrayList<ColumnInfo>();
        int columnCount = metaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String table = metaData.getTableName(i + 1);
            String colname = metaData.getColumnName(i + 1);
            String colType = metaData.getColumnTypeName(i + 1);
            ColumnInfo tableInfo = new ColumnInfo();
            tableInfo.setTable(table);
            tableInfo.setName(colname);
            tableInfo.setDataType(colType);
            colnames.add(tableInfo);
        }
        return colnames;
    }
}

