/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.config.LoadConfig;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.KoUtil;
import jakarta.annotation.Resource;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.redis.core.StringRedisTemplate;

@ComponentScan(value={"cn.langpy.kotime"})
@AutoConfiguration
public class KoTimeRunner
implements ApplicationRunner {
    private static Logger log = Logger.getLogger(KoTimeRunner.class.toString());
    @Resource
    private LoadConfig loadConfig;

    public void run(ApplicationArguments args) throws Exception {
        this.loadConfig.initConfig();
        this.setFinalDataSource();
    }

    private void setFinalDataSource() {
        StringRedisTemplate redisTemplate;
        DataSource dataSource = KoUtil.getDataSource();
        if (null != dataSource) {
            log.info("kotime=>Setting the finnal DataSource for kotime so that previous DataSources will be invalid.");
            Context.setDataSource(dataSource);
        }
        if (null != (redisTemplate = KoUtil.getStringRedisTemplate())) {
            log.info("kotime=>Setting the finnal StringRedisTemplate for kotime so that previous StringRedisTemplate will be invalid.");
            Context.setStringRedisTemplate(redisTemplate);
        }
        if (Context.getConfig().getDataReset().booleanValue()) {
            log.info("kotime=>Deleting all data for kotime.");
            GraphService instance = GraphService.getInstance();
            instance.clearAll();
        }
        KoUtil.clearCaches();
    }
}

