/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHttpClient
implements IHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(NativeHttpClient.class);
    private static final String KEYWORDS_CONNECT_TIMED_OUT = "connect timed out";
    private static final String KEYWORDS_READ_TIMED_OUT = "Read timed out";
    private final int _connectionTimeout;
    private final int _readTimeout;
    private final int _maxRetryTimes;
    private final String _sslVer;
    private final String _encryptType;
    private String _authCode;
    private HttpProxy _proxy;

    public NativeHttpClient(String authCode, HttpProxy proxy, ClientConfig config) {
        this._maxRetryTimes = config.getMaxRetryTimes();
        this._connectionTimeout = config.getConnectionTimeout();
        this._readTimeout = config.getReadTimeout();
        this._sslVer = config.getSSLVersion();
        this._encryptType = config.getEncryptType();
        this._authCode = authCode;
        this._proxy = proxy;
        String message = MessageFormat.format("Created instance with connectionTimeout {0}, readTimeout {1}, maxRetryTimes {2}, SSL Version {3}", this._connectionTimeout, this._readTimeout, this._maxRetryTimes, this._sslVer);
        LOG.debug(message);
        if (null != this._proxy && this._proxy.isAuthenticationNeeded()) {
            Authenticator.setDefault(new SimpleProxyAuthenticator(this._proxy.getUsername(), this._proxy.getPassword()));
        }
        this.initSSL(this._sslVer);
    }

    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        return this.sendGet(url, null);
    }

    @Override
    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.GET);
    }

    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        return this.sendDelete(url, null);
    }

    @Override
    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.DELETE);
    }

    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.POST);
    }

    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        return this.doRequest(url, content, IHttpClient.RequestMethod.PUT);
    }

    public ResponseWrapper doRequest(String url, String content, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = null;
        int retryTimes = 0;
        while (true) {
            try {
                response = this._doRequest(url, content, method);
            }
            catch (SocketTimeoutException e) {
                if (KEYWORDS_READ_TIMED_OUT.equals(e.getMessage())) {
                    throw new APIConnectionException("Read timed out. \nRead response from JPush Server timed out. \nIf this is a Push action, you may not want to retry. \nIt may be due to slowly response from JPush server, or unstable connection. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, true);
                }
                if (retryTimes >= this._maxRetryTimes) {
                    throw new APIConnectionException("connect timed out. \nConnect to JPush Server timed out, and already retried some times. \nPlease ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e, retryTimes);
                }
                LOG.debug("connect timed out - retry again - " + (retryTimes + 1));
                ++retryTimes;
                continue;
            }
            break;
        }
        return response;
    }

    private ResponseWrapper _doRequest(String url, String content, IHttpClient.RequestMethod method) throws APIConnectionException, APIRequestException, SocketTimeoutException {
        ResponseWrapper wrapper;
        block41: {
            LOG.debug("Send request - " + method.toString() + " " + url);
            if (null != content) {
                LOG.debug("Request Content - " + content);
            }
            HttpURLConnection conn = null;
            OutputStream out = null;
            InputStream in = null;
            InputStreamReader reader = null;
            StringBuffer sb = new StringBuffer();
            wrapper = new ResponseWrapper();
            try {
                URL aUrl = new URL(url);
                conn = this.getConnectionByUrl(aUrl);
                conn.setConnectTimeout(this._connectionTimeout);
                conn.setReadTimeout(this._readTimeout);
                conn.setUseCaches(false);
                conn.setRequestMethod(method.name());
                if (!StringUtils.isEmpty(this._encryptType)) {
                    conn.setRequestProperty("X-Encrypt-Type", this._encryptType);
                }
                conn.setRequestProperty("User-Agent", "JPush-API-Java-Client");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("Charset", "UTF-8");
                conn.setRequestProperty("Authorization", this._authCode);
                conn.setRequestProperty("Content-Type", "application/json");
                if (null == content) {
                    conn.setDoOutput(false);
                } else {
                    conn.setDoOutput(true);
                    byte[] data = content.getBytes("UTF-8");
                    conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                    out = conn.getOutputStream();
                    out.write(data);
                    out.flush();
                }
                int status = conn.getResponseCode();
                in = status / 100 == 2 ? conn.getInputStream() : conn.getErrorStream();
                if (null != in) {
                    int len;
                    reader = new InputStreamReader(in, "UTF-8");
                    char[] buff = new char[1024];
                    while ((len = reader.read(buff)) > 0) {
                        sb.append(buff, 0, len);
                    }
                }
                String responseContent = sb.toString();
                wrapper.responseCode = status;
                wrapper.responseContent = responseContent;
                String quota = conn.getHeaderField("X-Rate-Limit-Limit");
                String remaining = conn.getHeaderField("X-Rate-Limit-Remaining");
                String reset = conn.getHeaderField("X-Rate-Limit-Reset");
                wrapper.setRateLimit(quota, remaining, reset);
                if (status >= 200 && status < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + status);
                    LOG.debug("Response Content - " + responseContent);
                    break block41;
                }
                if (status >= 300 && status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
                    break block41;
                }
                LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
                switch (status) {
                    case 400: {
                        LOG.error("Your request params is invalid. Please check them according to error message.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 401: {
                        LOG.error("Authentication failed! Please check authentication params according to docs.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 403: {
                        LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 404: {
                        LOG.error("Request page is not found! Maybe your params is invalid.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 410: {
                        LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                        wrapper.setErrorObject();
                    }
                    case 429: {
                        LOG.error("Too many requests! Please review your appkey's request quota.");
                        wrapper.setErrorObject();
                        break;
                    }
                    case 500: 
                    case 502: 
                    case 503: 
                    case 504: {
                        LOG.error("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                        break;
                    }
                    default: {
                        LOG.error("Unexpected response.");
                    }
                }
                throw new APIRequestException(wrapper);
            }
            catch (SocketTimeoutException e) {
                if (e.getMessage().contains(KEYWORDS_CONNECT_TIMED_OUT)) {
                    throw e;
                }
                if (e.getMessage().contains(KEYWORDS_READ_TIMED_OUT)) {
                    throw new SocketTimeoutException(KEYWORDS_READ_TIMED_OUT);
                }
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            catch (IOException e) {
                LOG.debug("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", (Throwable)e);
                throw new APIConnectionException("Connection IO error. \nCan not connect to JPush Server. Please ensure your internet connection is ok. \nIf the problem persists, please let us know at support@jpush.cn.", e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close stream.", (Throwable)e);
                    }
                }
                if (null != conn) {
                    conn.disconnect();
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return wrapper;
    }

    protected void initSSL(String sslVer) {
        TrustManager[] tmCerts = new TrustManager[]{new SimpleTrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance(sslVer);
            sslContext.init(null, tmCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            SimpleHostnameVerifier hostnameVerifier = new SimpleHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception e) {
            LOG.error("Init SSL error", (Throwable)e);
        }
    }

    public String formUploadByPut(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType) {
        return this.formUpload(urlStr, textMap, fileMap, contentType, "PUT");
    }

    public String formUploadByPost(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType) {
        return this.formUpload(urlStr, textMap, fileMap, contentType, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formUpload(String urlStr, Map<String, String> textMap, Map<String, String> fileMap, String contentType, String requestMethod) {
        String res = "";
        HttpURLConnection conn = null;
        String BOUNDARY = "---------------------------" + System.currentTimeMillis();
        try {
            URL url = new URL(urlStr);
            conn = this.getConnectionByUrl(url);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Authorization", this._authCode);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (textMap != null) {
                StringBuffer strBuf = new StringBuffer();
                for (Map.Entry<String, String> entry : textMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                ((OutputStream)out).write(strBuf.toString().getBytes());
            }
            if (fileMap != null) {
                for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    File file = new File(inputValue);
                    String filename = file.getName();
                    contentType = new MimetypesFileTypeMap().getContentType(file);
                    if (!"".equals(contentType)) {
                        if (filename.endsWith(".png")) {
                            contentType = "image/png";
                        } else if (filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".jpe")) {
                            contentType = "image/jpeg";
                        } else if (filename.endsWith(".gif")) {
                            contentType = "image/gif";
                        } else if (filename.endsWith(".ico")) {
                            contentType = "image/image/x-icon";
                        }
                    }
                    if (contentType == null || "".equals(contentType)) {
                        contentType = "application/octet-stream";
                    }
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n");
                    strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                    ((OutputStream)out).write(strBuf.toString().getBytes());
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    int bytes = 0;
                    byte[] bufferOut = new byte[1024];
                    while ((bytes = in.read(bufferOut)) != -1) {
                        ((OutputStream)out).write(bufferOut, 0, bytes);
                    }
                    in.close();
                }
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer strBuf = new StringBuffer();
            Object is = null;
            int responseCode = conn.getResponseCode();
            BufferedReader reader = responseCode == 200 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            res = strBuf.toString();
            reader.close();
            reader = null;
        }
        catch (FileNotFoundException e) {
            LOG.error("formUpload error", (Throwable)e);
            throw new RuntimeException("formUpload error", e);
        }
        catch (Exception e) {
            LOG.error("formUpload error", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return res;
    }

    public HttpURLConnection getConnectionByUrl(URL url) throws IOException {
        HttpURLConnection conn;
        if (null != this._proxy) {
            conn = (HttpURLConnection)url.openConnection(this._proxy.getNetProxy());
            if (this._proxy.isAuthenticationNeeded()) {
                conn.setRequestProperty("Proxy-Authorization", this._proxy.getProxyAuthorization());
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        return conn;
    }

    public static class SimpleProxyAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public SimpleProxyAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static class SimpleTrustManager
    implements TrustManager,
    X509TrustManager {
        private SimpleTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class SimpleHostnameVerifier
    implements HostnameVerifier {
        private SimpleHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

