/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.number;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumUtils {
    private static final int DEF_DIV_SCALE = 10;
    private static final String CHINESE_LOWER_NUM_UNIT = "\u5343\u767e\u5341\u4ebf\u5343\u767e\u5341\u4e07\u5343\u767e\u5341";
    private static final String CHINESE_LOWER_NUM_CHAR = "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    private static final String CHINESE_LOWER_NUM_10 = "\u4e00\u5341";
    private static final String CHINESE_UPPER_NUM_UNIT = "\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe";
    private static final String CHINESE_UPPER_NUM_CHAR = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
    private static final String CHINESE_UPPER_NUM_10 = "\u58f9\u62fe";

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return NumUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u5c0f\u6570\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570\u6216\u96f6");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        if (b1.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.doubleValue();
        }
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u5c0f\u6570\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570\u6216\u96f6");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String toChineseLowerNumeral(String num) {
        return NumUtils.toChineseNumeral(String.valueOf(num), CHINESE_LOWER_NUM_UNIT, CHINESE_LOWER_NUM_CHAR, CHINESE_LOWER_NUM_10);
    }

    public static String toChineseUpperNumeral(String num) {
        return NumUtils.toChineseNumeral(String.valueOf(num), CHINESE_UPPER_NUM_UNIT, CHINESE_UPPER_NUM_CHAR, CHINESE_UPPER_NUM_10);
    }

    public static String toWrittenAmount(double num) {
        DecimalFormat df = new DecimalFormat("#,###.00");
        return df.format(num);
    }

    public static String toWrittenAmount(long num) {
        DecimalFormat df = new DecimalFormat("#,###");
        return df.format(num);
    }

    private static String toChineseNumeral(String num, String sUnit, String sNumChar, String num10) {
        int i;
        int pos = num.indexOf(46);
        String sBeforeDot = "";
        String sAfterDot = "";
        if (pos == -1) {
            sBeforeDot = num;
        } else {
            sBeforeDot = num.substring(0, pos);
            sAfterDot = num.substring(pos + 1);
        }
        String sRet = "";
        char c = '\u0000';
        for (i = 0; i < sBeforeDot.length(); ++i) {
            c = sBeforeDot.charAt(i);
            if (c == '0') {
                if (i >= sBeforeDot.length() - 1) continue;
                String sTmp = sUnit.substring(sUnit.length() - sBeforeDot.length() + i + 1, sUnit.length() - sBeforeDot.length() + i + 2);
                if (sTmp.equals("\u4ebf") || sTmp.equals("\u4e07")) {
                    if (sRet.substring(sRet.length() - 1).equals("\u96f6")) {
                        sRet = sRet.substring(0, sRet.length() - 1);
                    }
                    if ((sRet.substring(sRet.length() - 1).equals("\u4ebf") || sRet.substring(sRet.length() - 1).equals("\u4e07")) && sTmp.equals("\u4e07")) continue;
                    sRet = sRet + sTmp;
                    continue;
                }
                if (sRet.substring(sRet.length() - 1).equals("\u96f6")) continue;
                sRet = sRet + "\u96f6";
                continue;
            }
            sRet = sRet + sNumChar.substring(c - 48, c - 48 + 1);
            if (i >= sBeforeDot.length() - 1) continue;
            sRet = sRet + sUnit.substring(sUnit.length() - sBeforeDot.length() + i + 1, sUnit.length() - sBeforeDot.length() + i + 2);
        }
        if (sRet.length() > 2 && sRet.substring(0, 2).equals(num10)) {
            sRet = sRet.substring(1);
        }
        if (sRet.substring(sRet.length() - 1).equals("\u96f6")) {
            sRet = sRet.substring(0, sRet.length() - 1);
        }
        if (sAfterDot.length() > 0) {
            sRet = sRet + "\u70b9";
            for (i = 0; i < sAfterDot.length(); ++i) {
                c = sAfterDot.charAt(i);
                sRet = sRet + sNumChar.substring(c - 48, c - 48 + 1);
            }
        }
        return sRet;
    }
}

