/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.io;

import cn.javaex.htool.core.io.FileUtils;
import cn.javaex.htool.core.io.IOUtils;
import cn.javaex.htool.core.io.handler.FileHandler;
import cn.javaex.htool.core.io.handler.FileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils
extends FileHelper {
    public static void zip(String srcPath, String zipPath) throws IOException {
        ZipUtils.zip(srcPath, zipPath, true);
    }

    public static void zip(String srcPath, String zipPath, boolean isKeepFolder) throws IOException {
        File srcFile = new File(srcPath);
        FileHandler.requireExists(srcFile);
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            FileUtils.deleteFileOrDirectory(zipFile);
        }
        byte[] buffer = new byte[10240];
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            if (srcFile.isFile()) {
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipEntry zipEntry = new ZipEntry(srcFile.getName());
                zos.putNextEntry(zipEntry);
                fis = new FileInputStream(srcFile);
                bis = new BufferedInputStream(fis, 10240);
                int read = 0;
                while ((read = bis.read(buffer, 0, 10240)) != -1) {
                    zos.write(buffer, 0, read);
                }
                zos.flush();
            } else if (srcFile.isDirectory()) {
                List<File> fileList = FileUtils.listDeepFiles(srcFile);
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                for (File file : fileList) {
                    String name = FileHandler.getRealName(srcPath, file);
                    ZipEntry zipEntry = null;
                    zipEntry = isKeepFolder ? new ZipEntry(new File(srcPath).getName() + File.separator + name) : new ZipEntry(name);
                    zipEntry.setSize(file.length());
                    zos.putNextEntry(zipEntry);
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis, 10240);
                    int read = 0;
                    while ((read = bis.read(buffer, 0, 10240)) != -1) {
                        zos.write(buffer, 0, read);
                    }
                    zos.flush();
                    bis.close();
                    fis.close();
                }
                zos.close();
            }
        }
        catch (IOException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zos);
        IOUtils.closeQuietly(fos);
        IOUtils.closeQuietly(bis);
        IOUtils.closeQuietly(fis);
    }

    public static void unZip(String zipPath, String destDirPath) throws IOException {
        File file = new File(zipPath);
        FileHandler.requireFile(file);
        byte[] buffer = new byte[10240];
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int read;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + File.separator + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(destDirPath + File.separator + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream in = zipFile.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(in, 10240);
                FileOutputStream fos = new FileOutputStream(targetFile);
                while ((read = bis.read(buffer, 0, 10240)) != -1) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                in.close();
            }
        }
        catch (IOException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zipFile);
    }
}

