/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.io;

import cn.javaex.htool.core.io.Charsets;
import cn.javaex.htool.core.io.IOUtils;
import cn.javaex.htool.core.io.handler.FileHandler;
import cn.javaex.htool.core.io.handler.FileHelper;
import cn.javaex.htool.core.io.handler.FilenameHandler;
import cn.javaex.htool.core.io.model.TreeFile;
import cn.javaex.htool.core.string.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FileUtils
extends FileHelper {
    public static void deleteFileOrDirectory(String path) throws IOException {
        File file = new File(path);
        FileUtils.deleteFileOrDirectory(file);
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        FileHandler.requireExists(file);
        if (!file.exists()) {
            return;
        }
        if (!FileHandler.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        file.delete();
    }

    public static void cleanDirectory(String path) throws IOException {
        File file = new File(path);
        FileUtils.cleanDirectory(file);
    }

    public static void cleanDirectory(File directory) throws IOException {
        FileHandler.requireExists(directory);
        if (!directory.exists()) {
            return;
        }
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = FileUtils.listFiles(directory)) {
                FileUtils.deleteFileOrDirectory(file);
            }
        }
    }

    public static File[] listFiles(String path) throws IOException {
        File directory = new File(path);
        return FileUtils.listFiles(directory);
    }

    public static File[] listFiles(File directory) throws IOException {
        FileHandler.requireDirectoryExists(directory);
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + directory);
        }
        return files;
    }

    public static List<File> listDeepFiles(String path) throws IOException {
        File directory = new File(path);
        return FileUtils.listDeepFiles(directory);
    }

    public static List<File> listDeepFiles(File directory) throws IOException {
        File[] files;
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files = FileUtils.listFiles(directory)) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            fileList.addAll(FileUtils.listDeepFiles(file));
        }
        return fileList;
    }

    public static List<TreeFile> listDeepFilesAndDirectorys(String path) throws IOException {
        File directory = new File(path);
        return FileUtils.listDeepFilesAndDirectorys(directory);
    }

    public static List<TreeFile> listDeepFilesAndDirectorys(File directory) throws IOException {
        File[] files;
        ArrayList<TreeFile> fileList = new ArrayList<TreeFile>();
        for (File file : files = FileUtils.listFiles(directory)) {
            TreeFile treeFile = new TreeFile();
            treeFile.setFile(file);
            if (file.isDirectory()) {
                List<TreeFile> listDeepFilesAndDirectorys = FileUtils.listDeepFilesAndDirectorys(file);
                treeFile.setChildren(listDeepFilesAndDirectorys);
            }
            fileList.add(treeFile);
        }
        return fileList;
    }

    public static void copyFile(String srcPath, String destPath) throws IOException {
        File srcFile = new File(srcPath);
        File destFile = new File(destPath);
        FileUtils.copyFile(srcFile, destFile);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileHandler.requireFileCopy(srcFile, destFile);
        FileHandler.requireFile(srcFile);
        FileHandler.requireCanonicalPathsNotEquals(srcFile, destFile);
        FileHandler.createParentDirectories(destFile);
        FileHandler.requireFileIfExists(destFile);
        if (destFile.exists()) {
            FileHandler.requireCanWrite(destFile);
        }
        Files.copy(srcFile.toPath(), destFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        FileHandler.requireEqualSizes(srcFile, destFile, srcFile.length(), destFile.length());
    }

    public static void copyDirectory(String srcPath, String destPath) throws IOException {
        File srcDir = new File(srcPath);
        File destDir = new File(destPath);
        FileUtils.copyDirectory(srcDir, destDir);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles;
        FileHandler.requireFileCopy(srcDir, destDir);
        FileHandler.requireDirectory(srcDir);
        FileHandler.requireCanonicalPathsNotEquals(srcDir, destDir);
        ArrayList<String> exclusionList = null;
        String srcDirCanonicalPath = srcDir.getCanonicalPath();
        String destDirCanonicalPath = destDir.getCanonicalPath();
        if (destDirCanonicalPath.startsWith(srcDirCanonicalPath) && (srcFiles = FileUtils.listFiles(srcDir)).length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
            }
        }
        FileUtils.doCopyDirectory(srcDir, destDir, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, List<String> exclusionList) throws IOException {
        File[] srcFiles;
        FileHandler.mkdirs(destDir);
        FileHandler.requireCanWrite(destDir);
        for (File srcFile : srcFiles = FileUtils.listFiles(srcDir)) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtils.doCopyDirectory(srcFile, dstFile, exclusionList);
                continue;
            }
            FileUtils.copyFile(srcFile, dstFile);
        }
    }

    public static void copyDirectoryToDirectory(String srcPath, String destPath) throws IOException {
        File srcDir = new File(srcPath);
        File destDir = new File(destPath);
        FileUtils.copyDirectoryToDirectory(srcDir, destDir);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileHandler.requireDirectory(srcDir);
        FileHandler.requireDirectoryIfExists(destDir);
        FileUtils.copyDirectory(srcDir, new File(destDir, srcDir.getName()));
    }

    public static void moveFile(String srcPath, String destPath) throws IOException {
        FileUtils.copyFile(srcPath, destPath);
        FileUtils.deleteFileOrDirectory(srcPath);
    }

    public static void moveDirectory(String srcPath, String destPath) throws IOException {
        FileUtils.copyDirectory(srcPath, destPath);
        FileUtils.deleteFileOrDirectory(srcPath);
    }

    public static void moveDirectoryToDirectory(String srcPath, String destPath) throws IOException {
        FileUtils.copyDirectoryToDirectory(srcPath, destPath);
        FileUtils.deleteFileOrDirectory(srcPath);
    }

    public static void forceMkdir(String directoryPath) throws IOException {
        FileUtils.forceMkdir(new File(directoryPath));
    }

    public static void forceMkdir(File directory) throws IOException {
        FileHandler.mkdirs(directory);
    }

    public static void write(String filePath, String data, String charsetName, boolean isAppend) throws IOException {
        FileUtils.write(new File(filePath), data, charsetName, isAppend);
    }

    public static void write(File file, String data, String charsetName, boolean isAppend) throws IOException {
        try (FileOutputStream output = IOUtils.openOutputStream(file, isAppend);){
            if (data != null) {
                ((OutputStream)output).write(data.getBytes(Charsets.toCharset(charsetName)));
            }
        }
    }

    public static String readFile(String filePath) throws IOException {
        return FileUtils.readFile(new File(filePath), null);
    }

    public static String readFile(File file) throws IOException {
        return FileUtils.readFile(file, null);
    }

    public static String readFile(String filePath, String charsetName) throws IOException {
        return FileUtils.readFile(new File(filePath), charsetName);
    }

    public static String readFile(File file, String charsetName) throws IOException {
        boolean checkFileSize = FileHandler.checkFileSize(file, 2, "G");
        if (checkFileSize) {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            return new String(bytes, Charsets.toCharset(charsetName));
        }
        try (FileInputStream inputStream = IOUtils.openInputStream(file);){
            String string = IOUtils.toString(inputStream, charsetName);
            return string;
        }
    }

    public static void downloadFileFromResource(String filePath) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFileFromResource(response, filePath);
    }

    public static void downloadFileFromResource(HttpServletResponse response, String filePath) {
        FileUtils.downloadFileFromResource(response, filePath, null);
    }

    public static void downloadFileFromResource(String filePath, String newFilename) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFileFromResource(response, filePath, newFilename);
    }

    public static void downloadFileFromResource(HttpServletResponse response, String filePath, String newFilename) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        FileUtils.downloadFile(response, inputStream, newFilename);
    }

    public static void downloadFile(String filePath) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFile(response, filePath);
    }

    public static void downloadFile(HttpServletResponse response, String filePath) {
        FileUtils.downloadFile(response, filePath, null);
    }

    public static void downloadFile(String filePath, String newFilename) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFile(response, filePath, newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, String filePath, String newFilename) {
        block7: {
            File file = new File(filePath);
            if (StringUtils.isEmpty(newFilename)) {
                newFilename = file.getName();
            }
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                int bytesRead;
                response.setContentType("application/octet-stream");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(newFilename, "UTF-8"));
                response.setHeader("Content-Length", String.valueOf(file.length()));
                bis = new BufferedInputStream(new FileInputStream(file));
                bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buff = new byte[1024];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                bos.flush();
                IOUtils.closeQuietly(bos);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(bis);
            }
            IOUtils.closeQuietly(bis);
        }
    }

    public static void downloadFile(InputStream inputStream, String newFilename) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFile(response, inputStream, newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, InputStream inputStream, String newFilename) {
        block6: {
            ServletOutputStream out = null;
            try {
                newFilename = URLEncoder.encode(newFilename, "UTF-8");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-disposition", "attachment; filename=" + newFilename);
                out = response.getOutputStream();
                int b = 0;
                byte[] buffer = new byte[1024];
                while ((b = inputStream.read(buffer)) != -1) {
                    out.write(buffer, 0, b);
                }
                out.flush();
                IOUtils.closeQuietly((Closeable)out);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void downloadFile(byte[] bytes, String newFilename) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        FileUtils.downloadFile(response, bytes, newFilename);
    }

    public static void downloadFile(HttpServletResponse response, byte[] bytes, String newFilename) {
        try (ServletOutputStream out = response.getOutputStream();){
            if (bytes != null) {
                newFilename = URLEncoder.encode(newFilename, "UTF-8");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-disposition", "attachment; filename=" + newFilename);
                out.write(bytes);
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getExtension(String filename) {
        if (StringUtils.isEmpty(filename)) {
            return filename;
        }
        for (String specialExtension : SPECIAL_EXTENSION) {
            if (!filename.endsWith("." + specialExtension)) continue;
            return specialExtension;
        }
        int index = FilenameHandler.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String getBaseName(String filename) {
        filename = FilenameHandler.getName(filename);
        String extension = FileUtils.getExtension(filename);
        return filename.replace("." + extension, "");
    }

    public static String getName(String filename) {
        if (StringUtils.isEmpty(filename)) {
            return filename;
        }
        int index = FilenameHandler.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getFullPath(String filename) {
        String name = FileUtils.getName(filename);
        int indexOf = filename.indexOf(name);
        return filename.substring(0, indexOf);
    }
}

