/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.id;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;

public class IdUtils {
    private static final long TWEPOCH = 1543376515623L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long DATA_CENTER_ID_BITS = 0L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 22L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static long WORKER_ID;
    private static long DATA_CENTER_ID;
    private static long SEQUENCE;
    private static long LAST_TIMESTAMP;

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static synchronized String getLongIdStr() {
        return String.valueOf(IdUtils.getLongId());
    }

    public static synchronized long getLongId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < LAST_TIMESTAMP) {
            throw new RuntimeException(String.format("Clock moved backwards", LAST_TIMESTAMP - timestamp));
        }
        if (LAST_TIMESTAMP == timestamp) {
            if ((SEQUENCE = SEQUENCE + 1L & 0xFFFL) == 0L) {
                timestamp = IdUtils.tilNextMillis(LAST_TIMESTAMP);
            }
        } else {
            SEQUENCE = 0L;
        }
        LAST_TIMESTAMP = timestamp;
        return timestamp - 1543376515623L << 22 | DATA_CENTER_ID << 22 | WORKER_ID << 12 | SEQUENCE;
    }

    private static String getSiteLocalIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.getName() == null || !networkInterface.getName().startsWith("eth")) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!inetAddress.isSiteLocalAddress() || inetAddress.isMulticastAddress()) continue;
                    return inetAddress.getHostAddress() == null ? "127.0.0.1" : inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError("get site local ip error.");
        }
        return "127.0.0.1";
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    static {
        SEQUENCE = 0L;
        LAST_TIMESTAMP = -1L;
        long localIp = Long.parseLong(IdUtils.getSiteLocalIp().replace(".", ""));
        WORKER_ID = localIp % 1023L;
        DATA_CENTER_ID = 0L;
    }
}

