/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date.handler;

import cn.javaex.htool.core.date.constant.DatePattern;
import cn.javaex.htool.core.date.handler.TimeHandler;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DateHandler
extends TimeHandler {
    public static final Map<String, Function<String, Date>> PARSE_MAP;
    public static final Map<String, Function<Date, String>> FORMAT_MAP;

    public Date parse(String text, String pattern) throws ParseException {
        Function<String, Date> func = PARSE_MAP.get(pattern);
        if (func != null) {
            return func.apply(text);
        }
        return new SimpleDateFormat(pattern).parse(text);
    }

    public LocalDateTime parseLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        return LocalDateTime.ofInstant(instant, ZONE);
    }

    public LocalDate parseLocalDate(Date date) {
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZONE);
        return localDateTime.toLocalDate();
    }

    static {
        Field[] fields;
        PARSE_MAP = new ConcurrentHashMap<String, Function<String, Date>>();
        FORMAT_MAP = new ConcurrentHashMap<String, Function<Date, String>>();
        for (Field field : fields = DatePattern.class.getDeclaredFields()) {
            try {
                String pattern = (String)field.get(DatePattern.class);
                PARSE_MAP.put(pattern, text -> {
                    try {
                        return new SimpleDateFormat(pattern).parse((String)text);
                    }
                    catch (ParseException parseException) {
                        return null;
                    }
                });
                FORMAT_MAP.put(pattern, date -> new SimpleDateFormat(pattern).format((Date)date));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

