/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date;

import cn.javaex.htool.core.date.TimeConversion;
import cn.javaex.htool.core.date.enums.TimeUnit;
import cn.javaex.htool.core.date.handler.TimeHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils
extends TimeConversion {
    public static List<String> getMonthBetweenDate(String startTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            while (startDate.getTime() <= endDate.getTime()) {
                list.add(sdf.format(startDate));
                calendar.setTime(startDate);
                calendar.add(2, 1);
                startDate = calendar.getTime();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Date getBeforeDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static String beginOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date lastMonthFirstDay = cal.getTime();
        try {
            return DateUtils.format(lastMonthFirstDay, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String endOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date lastMonthLastDay = cal.getTime();
        try {
            return DateUtils.format(lastMonthLastDay, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String today() {
        try {
            return DateUtils.format(LocalDate.now(), "yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String beginOfToday() {
        try {
            return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MIN), "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String endOfToday() {
        try {
            return DateUtils.format(LocalDateTime.of(LocalDate.now(), LocalTime.MAX), "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> String beginOfDay(T time) throws ParseException {
        String timestr = new TimeHandler().format(time, "yyyy-MM-dd");
        LocalDate localDate = DateUtils.parseLocalDate(timestr, "yyyy-MM-dd");
        return DateUtils.format(LocalDateTime.of(localDate, LocalTime.MIN), "yyyy-MM-dd HH:mm:ss");
    }

    public static <T> String endOfDay(T time) throws ParseException {
        String timestr = new TimeHandler().format(time, "yyyy-MM-dd");
        LocalDate localDate = DateUtils.parseLocalDate(timestr, "yyyy-MM-dd");
        return DateUtils.format(LocalDateTime.of(localDate, LocalTime.MAX), "yyyy-MM-dd HH:mm:ss");
    }

    public static String firstDayOfMonth() {
        LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        try {
            return DateUtils.format(firstDayOfMonth, "yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String beginOfMonth() {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()), LocalTime.MIN);
        try {
            return DateUtils.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dayOfMonth(int n) throws ParseException {
        return DateUtils.format(LocalDate.now().withDayOfMonth(n), "yyyy-MM-dd");
    }

    public static String lastDayOfMonth() {
        try {
            return DateUtils.format(LocalDate.now().with(TemporalAdjusters.lastDayOfMonth()), "yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String endOfMonth() {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now().with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MAX);
        try {
            return DateUtils.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getYear() {
        return LocalDateTime.now().getYear();
    }

    public static int getYear(Date date) {
        return DateUtils.parseLocalDateTime(date).getYear();
    }

    public static int getMonth() {
        return LocalDateTime.now().getMonthValue();
    }

    public static int getMonth(Date date) {
        return DateUtils.parseLocalDateTime(date).getMonthValue();
    }

    public static int getDayOfYear() {
        return LocalDateTime.now().getDayOfYear();
    }

    public static int getDayOfYear(Date date) {
        return DateUtils.parseLocalDateTime(date).getDayOfYear();
    }

    public static int getDayOfMonth() {
        return LocalDateTime.now().getDayOfMonth();
    }

    public static int getDayOfMonth(Date date) {
        return DateUtils.parseLocalDateTime(date).getDayOfMonth();
    }

    public static int getDayOfWeek() {
        return LocalDateTime.now().getDayOfWeek().getValue();
    }

    public static int getDayOfWeek(Date date) {
        return DateUtils.parseLocalDateTime(date).getDayOfWeek().getValue();
    }

    public static int getHour() {
        return LocalDateTime.now().getHour();
    }

    public static int getHour(Date date) {
        return DateUtils.parseLocalDateTime(date).getHour();
    }

    public static int getMinute() {
        return LocalDateTime.now().getMinute();
    }

    public static int getMinute(Date date) {
        return DateUtils.parseLocalDateTime(date).getMinute();
    }

    public static int getSecond() {
        return LocalDateTime.now().getSecond();
    }

    public static int getSecond(Date date) {
        return DateUtils.parseLocalDateTime(date).getSecond();
    }

    public static <T> long timeDifference(T time1, T time2, String accuracy) throws ParseException {
        if (time1 == null || time2 == null || accuracy == null) {
            throw new RuntimeException("Parameter cannot be null");
        }
        TimeUnit timeUnit = TimeUnit.find(accuracy.toLowerCase());
        switch (timeUnit) {
            case YEAR: {
                return new TimeHandler().yearDifference(time1, time2);
            }
            case MONTH: {
                return new TimeHandler().monthDifference(time1, time2);
            }
            case DAY: {
                return new TimeHandler().dayDifference(time1, time2);
            }
            case HOUR: {
                return new TimeHandler().hourDifference(time1, time2);
            }
            case MINUTE: {
                return new TimeHandler().minuteDifference(time1, time2);
            }
            case SECOND: {
                return new TimeHandler().secondDifference(time1, time2);
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u5904\u7406" + accuracy + "\u7c7b\u578b\u7684\u8ba1\u7b97");
    }

    public static <T> int compare(T time1, T time2) throws ParseException {
        LocalDateTime localDateTime2;
        String timestr1 = new TimeHandler().format(time1, "yyyy-MM-dd HH:mm:ss");
        String timestr2 = new TimeHandler().format(time2, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime1 = DateUtils.parseLocalDateTime(timestr1, "yyyy-MM-dd HH:mm:ss");
        if (localDateTime1.equals(localDateTime2 = DateUtils.parseLocalDateTime(timestr2, "yyyy-MM-dd HH:mm:ss"))) {
            return 0;
        }
        return localDateTime1.isBefore(localDateTime2) ? -1 : 1;
    }

    public static Date plusYears(Date date, long years) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusYears(years));
    }

    public static Date plusMonths(Date date, long months) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusMonths(months));
    }

    public static Date plusWeeks(Date date, long weeks) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusWeeks(weeks));
    }

    public static Date plusDays(Date date, long days) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusDays(days));
    }

    public static Date plusHours(Date date, long hours) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusHours(hours));
    }

    public static Date plusMinutes(Date date, long minutes) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusMinutes(minutes));
    }

    public static Date plusSeconds(Date date, long seconds) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).plusSeconds(seconds));
    }

    public static Date minusYears(Date date, long years) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusYears(years));
    }

    public static Date minusMonths(Date date, long months) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusMonths(months));
    }

    public static Date minusWeeks(Date date, long weeks) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusWeeks(weeks));
    }

    public static Date minusDays(Date date, long days) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusDays(days));
    }

    public static Date minusHours(Date date, long hours) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusHours(hours));
    }

    public static Date minusMinutes(Date date, long minutes) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusMinutes(minutes));
    }

    public static Date minusSeconds(Date date, long seconds) {
        return DateUtils.parseDate(DateUtils.parseLocalDateTime(date).minusSeconds(seconds));
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(String time, String pattern) throws ParseException {
        LocalDate time1 = DateUtils.parseLocalDate(time, pattern);
        LocalDate time2 = LocalDate.now();
        return (int)DateUtils.timeDifference(time1, time2, TimeUnit.YEAR.getValue());
    }

    public static <T> int age(T time) throws ParseException {
        String timestr1 = new TimeHandler().format(time, "yyyy-MM-dd");
        LocalDate time1 = DateUtils.parseLocalDate(timestr1, "yyyy-MM-dd");
        LocalDate time2 = LocalDate.now();
        return (int)DateUtils.timeDifference(time1, time2, TimeUnit.YEAR.getValue());
    }

    public static String getZodiac(int year) {
        if (year < 1990) {
            return "\u672a\u77e5";
        }
        return ZODIACS[(year - 1900) % ZODIACS.length];
    }

    public static String getConstellation(int month, int day) {
        return day < CONSTELLATION_DAYS[month - 1] ? CONSTELLATIONS[month - 1] : CONSTELLATIONS[month];
    }
}

