/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.string.zh;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ZHConverter {
    public static final int TC = 0;
    public static final int SC = 1;
    private static final int NUM_OF_CONVERTERS = 2;
    private static final ZHConverter[] CONVERTERS = new ZHConverter[2];
    private static final String[] PROPERTY_FILES = new String[2];
    private Properties charMap = new Properties();
    private Set<Object> conflictingSets = new HashSet<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZHConverter getInstance(int converterType) {
        if (converterType < 0 || converterType >= 2) return null;
        if (CONVERTERS[converterType] != null) return CONVERTERS[converterType];
        Class<ZHConverter> clazz = ZHConverter.class;
        synchronized (ZHConverter.class) {
            if (CONVERTERS[converterType] != null) return CONVERTERS[converterType];
            ZHConverter.CONVERTERS[converterType] = new ZHConverter(PROPERTY_FILES[converterType]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CONVERTERS[converterType];
        }
    }

    public static String convert(String text, int converterType) {
        ZHConverter instance = ZHConverter.getInstance(converterType);
        return instance.convert(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZHConverter(String propertyFile) {
        InputStream is = this.getClass().getResourceAsStream(propertyFile);
        if (is != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                this.charMap.load(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.initializeHelper();
    }

    private void initializeHelper() {
        HashMap<String, Integer> stringPossibilities = new HashMap<String, Integer>();
        for (String string : this.charMap.keySet()) {
            if (string.length() < 1) continue;
            for (int i = 0; i < string.length(); ++i) {
                String keySubstring = string.substring(0, i + 1);
                if (stringPossibilities.containsKey(keySubstring)) {
                    Integer integer = (Integer)stringPossibilities.get(keySubstring);
                    stringPossibilities.put(keySubstring, new Integer(integer + 1));
                    continue;
                }
                stringPossibilities.put(keySubstring, new Integer(1));
            }
        }
        for (String string : stringPossibilities.keySet()) {
            if ((Integer)stringPossibilities.get(string) <= 1) continue;
            this.conflictingSets.add(string);
        }
    }

    public String convert(String in) {
        StringBuilder outString = new StringBuilder();
        StringBuilder stackString = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            String key = "" + c;
            stackString.append(key);
            if (this.conflictingSets.contains(stackString.toString())) continue;
            if (this.charMap.containsKey(stackString.toString())) {
                outString.append(this.charMap.get(stackString.toString()));
                stackString.setLength(0);
                continue;
            }
            CharSequence sequence = stackString.subSequence(0, stackString.length() - 1);
            stackString.delete(0, stackString.length() - 1);
            this.flushStack(outString, new StringBuilder(sequence));
        }
        this.flushStack(outString, stackString);
        return outString.toString();
    }

    private void flushStack(StringBuilder outString, StringBuilder stackString) {
        while (stackString.length() > 0) {
            if (this.charMap.containsKey(stackString.toString())) {
                outString.append(this.charMap.get(stackString.toString()));
                stackString.setLength(0);
                continue;
            }
            outString.append("" + stackString.charAt(0));
            stackString.delete(0, 1);
        }
    }

    static {
        ZHConverter.PROPERTY_FILES[0] = "zh2Hant.properties";
        ZHConverter.PROPERTY_FILES[1] = "zh2Hans.properties";
    }
}

