/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.string;

import cn.javaex.htool.core.date.DateUtils;
import cn.javaex.htool.core.regular.CheckUtils;
import cn.javaex.htool.core.string.StringUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IDCardUtils {
    private static final Map<String, String> PROVINCE_CODES = new HashMap<String, String>();
    private static final Map<Character, Integer> TW_FIRST_CODE = new HashMap<Character, Integer>();
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean isIDCard(String idCard) {
        if (StringUtils.isBlank(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return IDCardUtils.isIDCard18(idCard);
            }
            case 15: {
                return IDCardUtils.isIDCard15(idCard);
            }
            case 10: {
                String[] cardVal = IDCardUtils.isIDCard10(idCard);
                return null != cardVal && "true".equals(cardVal[2]);
            }
        }
        return false;
    }

    public static String getBirthday(String idCard) {
        if (!IDCardUtils.isIDCard(idCard)) {
            return "";
        }
        String birthday = "";
        int len = idCard.length();
        birthday = len == 18 ? idCard.substring(6, 14) : "19" + idCard.substring(6, 12);
        return birthday.substring(0, 4) + "-" + birthday.substring(4, 6) + "-" + birthday.substring(6, 8);
    }

    public static int getAge(String idCard) {
        if (!IDCardUtils.isIDCard(idCard)) {
            return 0;
        }
        String birthday = "";
        int len = idCard.length();
        birthday = len == 18 ? idCard.substring(6, 14) : "19" + idCard.substring(6, 12);
        try {
            return DateUtils.age(birthday, "yyyy-MM-dd".replace("-", ""));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getGender(String idCard) {
        char sCardChar;
        if (!IDCardUtils.isIDCard(idCard)) {
            throw new IllegalArgumentException("Invalid IDCard");
        }
        int len = idCard.length();
        if (len == 15) {
            idCard = IDCardUtils.convert15To18(idCard);
        }
        return (sCardChar = Objects.requireNonNull(idCard).charAt(16)) % 2 != 0 ? 1 : 0;
    }

    public static String convert15To18(String idCard) {
        if (!IDCardUtils.isIDCard(idCard)) {
            throw new IllegalArgumentException("Invalid IDCard");
        }
        if (idCard.length() != 15) {
            return null;
        }
        String birthday = "19" + idCard.substring(6, 12);
        StringBuffer idCard18 = new StringBuffer();
        idCard18.append(idCard, 0, 6).append(birthday.substring(0, 4)).append(idCard.substring(8));
        char val = IDCardUtils.getCheckCode18(idCard18.toString());
        idCard18.append(val);
        return idCard18.toString();
    }

    public static String getProvinceCode(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 2);
        }
        return null;
    }

    public static String getProvince(String idCard) {
        String code = IDCardUtils.getProvinceCode(idCard);
        if (StringUtils.isNotBlank(code)) {
            return PROVINCE_CODES.get(code);
        }
        return null;
    }

    public static String getCityCode(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 4);
        }
        return null;
    }

    public static String getDistrictCode(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            return idCard.substring(0, 6);
        }
        return null;
    }

    private static boolean isIDCard18(String idCard) {
        int day;
        int month;
        String proCode = idCard.substring(0, 2);
        if (null == PROVINCE_CODES.get(proCode)) {
            return false;
        }
        String birthday = idCard.substring(6, 14);
        int year = Integer.parseInt(birthday.substring(0, 4));
        if (!IDCardUtils.isBirthday(year, month = Integer.parseInt(birthday.substring(4, 6)), day = Integer.parseInt(birthday.substring(6, 8)))) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        if (CheckUtils.isNumber(code17)) {
            char val = IDCardUtils.getCheckCode18(code17);
            return Character.toLowerCase(val) == Character.toLowerCase(idCard.charAt(17));
        }
        return false;
    }

    private static boolean isIDCard15(String idCard) {
        if (CheckUtils.isNumber(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (null == PROVINCE_CODES.get(proCode)) {
                return false;
            }
            String birthday = "19" + idCard.substring(6, 12);
            int year = Integer.parseInt(birthday.substring(0, 4));
            int month = Integer.parseInt(birthday.substring(4, 6));
            int day = Integer.parseInt(birthday.substring(6, 8));
            return IDCardUtils.isBirthday(year, month, day);
        }
        return false;
    }

    private static String[] isIDCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[()]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            char char2 = idCard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if ('2' == char2) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IDCardUtils.isTWIDCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
            info[2] = "true";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IDCardUtils.isHKIDCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    private static boolean isHKIDCard(String idCard) {
        int sum;
        String card = idCard.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    private static boolean isTWIDCard(String idCard) {
        Integer iStart = TW_FIRST_CODE.get(Character.valueOf(idCard.charAt(0)));
        if (null == iStart) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        String mid = idCard.substring(1, 9);
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        String end = idCard.substring(9, 10);
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    private static char getCheckCode18(String code17) {
        int sum = IDCardUtils.getPowerSum(code17.toCharArray());
        return IDCardUtils.getCheckCode18(sum);
    }

    private static int getPowerSum(char[] iArr) {
        int sum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                sum += Integer.parseInt(String.valueOf(iArr[i])) * POWER[i];
            }
        }
        return sum;
    }

    private static char getCheckCode18(int sum) {
        switch (sum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'X';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateUtils.getYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && DateUtils.isLeapYear(year);
        }
        return true;
    }

    static {
        PROVINCE_CODES.put("11", "\u5317\u4eac\u5e02");
        PROVINCE_CODES.put("12", "\u5929\u6d25\u5e02");
        PROVINCE_CODES.put("13", "\u6cb3\u5317\u7701");
        PROVINCE_CODES.put("14", "\u5c71\u897f\u7701");
        PROVINCE_CODES.put("15", "\u5185\u8499\u53e4\u81ea\u6cbb\u533a");
        PROVINCE_CODES.put("21", "\u8fbd\u5b81\u7701");
        PROVINCE_CODES.put("22", "\u5409\u6797\u7701");
        PROVINCE_CODES.put("23", "\u9ed1\u9f99\u6c5f\u7701");
        PROVINCE_CODES.put("31", "\u4e0a\u6d77\u5e02");
        PROVINCE_CODES.put("32", "\u6c5f\u82cf\u7701");
        PROVINCE_CODES.put("33", "\u6d59\u6c5f\u7701");
        PROVINCE_CODES.put("34", "\u5b89\u5fbd\u7701");
        PROVINCE_CODES.put("35", "\u798f\u5efa\u7701");
        PROVINCE_CODES.put("36", "\u6c5f\u897f\u7701");
        PROVINCE_CODES.put("37", "\u5c71\u4e1c\u7701");
        PROVINCE_CODES.put("41", "\u6cb3\u5357\u7701");
        PROVINCE_CODES.put("42", "\u6e56\u5317\u7701");
        PROVINCE_CODES.put("43", "\u6e56\u5357\u7701");
        PROVINCE_CODES.put("44", "\u5e7f\u4e1c\u7701");
        PROVINCE_CODES.put("45", "\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a");
        PROVINCE_CODES.put("46", "\u6d77\u5357\u7701");
        PROVINCE_CODES.put("50", "\u91cd\u5e86\u5e02");
        PROVINCE_CODES.put("51", "\u56db\u5ddd\u7701");
        PROVINCE_CODES.put("52", "\u8d35\u5dde\u7701");
        PROVINCE_CODES.put("53", "\u4e91\u5357\u7701");
        PROVINCE_CODES.put("54", "\u897f\u85cf\u81ea\u6cbb\u533a");
        PROVINCE_CODES.put("61", "\u9655\u897f\u7701");
        PROVINCE_CODES.put("62", "\u7518\u8083\u7701");
        PROVINCE_CODES.put("63", "\u9752\u6d77\u7701");
        PROVINCE_CODES.put("64", "\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a");
        PROVINCE_CODES.put("65", "\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a");
        PROVINCE_CODES.put("71", "\u53f0\u6e7e\u7701");
        PROVINCE_CODES.put("81", "\u9999\u6e2f");
        PROVINCE_CODES.put("82", "\u6fb3\u95e8");
        PROVINCE_CODES.put("83", "\u53f0\u6e7e");
        PROVINCE_CODES.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put(Character.valueOf('A'), 10);
        TW_FIRST_CODE.put(Character.valueOf('B'), 11);
        TW_FIRST_CODE.put(Character.valueOf('C'), 12);
        TW_FIRST_CODE.put(Character.valueOf('D'), 13);
        TW_FIRST_CODE.put(Character.valueOf('E'), 14);
        TW_FIRST_CODE.put(Character.valueOf('F'), 15);
        TW_FIRST_CODE.put(Character.valueOf('G'), 16);
        TW_FIRST_CODE.put(Character.valueOf('H'), 17);
        TW_FIRST_CODE.put(Character.valueOf('J'), 18);
        TW_FIRST_CODE.put(Character.valueOf('K'), 19);
        TW_FIRST_CODE.put(Character.valueOf('L'), 20);
        TW_FIRST_CODE.put(Character.valueOf('M'), 21);
        TW_FIRST_CODE.put(Character.valueOf('N'), 22);
        TW_FIRST_CODE.put(Character.valueOf('P'), 23);
        TW_FIRST_CODE.put(Character.valueOf('Q'), 24);
        TW_FIRST_CODE.put(Character.valueOf('R'), 25);
        TW_FIRST_CODE.put(Character.valueOf('S'), 26);
        TW_FIRST_CODE.put(Character.valueOf('T'), 27);
        TW_FIRST_CODE.put(Character.valueOf('U'), 28);
        TW_FIRST_CODE.put(Character.valueOf('V'), 29);
        TW_FIRST_CODE.put(Character.valueOf('X'), 30);
        TW_FIRST_CODE.put(Character.valueOf('Y'), 31);
        TW_FIRST_CODE.put(Character.valueOf('W'), 32);
        TW_FIRST_CODE.put(Character.valueOf('Z'), 33);
        TW_FIRST_CODE.put(Character.valueOf('I'), 34);
        TW_FIRST_CODE.put(Character.valueOf('O'), 35);
    }
}

