/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.regular;

import cn.javaex.htool.core.string.IDCardUtils;
import java.util.regex.Pattern;

public class CheckUtils {
    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static boolean isMobile(String value) {
        String regex = "(?:0|86|\\+86)?1[3-9]\\d{9}";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isMobileHK(String value) {
        String regex = "(?:0|852|\\+852)?\\d{8}";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isMobileTW(String value) {
        String regex = "(?:0|886|\\+886)?(?:|-)09\\d{8}";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isMobileMO(String value) {
        String regex = "(?:0|853|\\+853)?(?:|-)6\\d{7}";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isTel(String value) {
        String regex = "(010|02\\d|0[3-9]\\d{2})-?(\\d{6,8})";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isTel400800(String value) {
        String regex = "0\\d{2,3}[\\- ]?[1-9]\\d{6,7}|[48]00[\\- ]?[1-9]\\d{6}";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isEmail(String value) {
        String regex = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isPostCode(String value) {
        String regex = "^(0[1-7]|1[0-356]|2[0-7]|3[0-6]|4[0-7]|5[0-7]|6[0-7]|7[0-5]|8[0-9]|9[0-8])\\d{4}|99907[78]$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isIpv4(String value) {
        String regex = "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isIpv6(String value) {
        String regex = "(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4})?:)?((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isMac(String value) {
        String regex = "((?:[a-fA-F0-9]{1,2}[:-]){5}[a-fA-F0-9]{1,2})|0x(\\d{12}).+ETHER";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isCarNumber(String value) {
        String regex = "^(([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z](([0-9]{5}[ABCDEFGHJK])|([ABCDEFGHJK]([A-HJ-NP-Z0-9])[0-9]{4})))|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886]\\d{3}\\d{1,3}[\u9886])|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z][A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3\u4f7f\u9886]))$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isCarVin(String value) {
        String regex = "^[A-HJ-NPR-Z0-9]{8}[0-9X][A-HJ-NPR-Z0-9]{2}\\d{6}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isCarDrivingLicence(String value) {
        String regex = "^[0-9]{12}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isIDCard(String value) {
        return IDCardUtils.isIDCard(value);
    }

    public static boolean isCreditCode(String value) {
        String regex = "^[0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isChinese(String value) {
        String chinese = "[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]";
        String chineses = chinese + "+";
        Pattern pattern = Pattern.compile(chineses);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isWord(String value) {
        String regex = "[a-zA-Z]+";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isHex(String value) {
        String regex = "^[a-fA-F0-9]+$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNumber(String value) {
        if (value != null && value.trim().length() > 0) {
            value = (value = value.trim()).charAt(0) == '-' ? value.substring(1) : value;
            String regex = "^\\d+$";
            Pattern pattern = Pattern.compile(regex);
            return CheckUtils.isMatch(pattern, value);
        }
        return false;
    }

    public static boolean isMoney(String value) {
        String decimal;
        String regex = "^(\\d+(?:\\.\\d+)?)$";
        Pattern pattern = Pattern.compile(regex);
        if (!CheckUtils.isMatch(pattern, value)) {
            return false;
        }
        return value.indexOf(".") <= 0 || (decimal = value.split("\\.")[1]).length() <= 2;
    }

    public static boolean isInt(String value) {
        String regex = "^-?\\d+$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isPositiveInt(String value) {
        String regex = "^[0-9]*[1-9][0-9]*$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNegativeInt(String value) {
        String regex = "^-[0-9]*[1-9][0-9]*$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNonnegativeInt(String value) {
        String regex = "^\\d+$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNonpositiveInt(String value) {
        String regex = "^((-\\d+)|(0+))$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isPositiveDecimal(String value) {
        String regex = "^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNegativeDecimal(String value) {
        String regex = "^(-(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*)))$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNonnegativeDecimal(String value) {
        String regex = "^\\d+(\\.\\d+)?$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNonpositiveDecimal(String value) {
        String regex = "^((-\\d+(\\.\\d+)?)|(0+(\\.0+)?))$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isAccount(String value) {
        String regex = "^[a-zA-Z]{1}([a-zA-Z0-9_]){5,10}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isNickname(String value) {
        String regex = "^[a-zA-Z0-9_\u4e00-\u9fa5]{2,10}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }

    public static boolean isPassword(String value) {
        String regex = "^[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{6,16}$";
        Pattern pattern = Pattern.compile(regex);
        return CheckUtils.isMatch(pattern, value);
    }
}

