/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.reflection;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtils {
    public static boolean hasCustomSuperClass(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        String superClassName = superClass.getName();
        return !"java.lang.Object".equalsIgnoreCase(superClassName);
    }

    public static Method getGetMethodByField(Class<?> clazz, String fieldName) {
        Method method = null;
        String getMethodName = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            Class<?> type = field.getType();
            getMethodName = ClassUtils.getGetMethodNameByFieldName(fieldName, type.getTypeName());
        }
        catch (NoSuchFieldException | SecurityException e1) {
            while (ClassUtils.hasCustomSuperClass(clazz)) {
                clazz = clazz.getSuperclass();
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    Class<?> type = field.getType();
                    getMethodName = ClassUtils.getGetMethodNameByFieldName(fieldName, type.getTypeName());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            method = clazz.getDeclaredMethod(getMethodName, new Class[0]);
        }
        catch (Exception e) {
            method = ClassUtils.getSuperClassMethod(clazz, getMethodName, new Class[0]);
        }
        return method;
    }

    public static Method getSetMethodByField(Class<?> clazz, Field field) {
        String setMethodName = ClassUtils.getSetMethodNameByFieldName(field.getName());
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(setMethodName, field.getType());
        }
        catch (Exception e) {
            method = ClassUtils.getSuperClassMethod(clazz, setMethodName, field.getType());
        }
        return method;
    }

    public static Method getSetMethodByField(Class<?> clazz, String fieldName) {
        Field field = ClassUtils.getDeclaredField(clazz, fieldName);
        return ClassUtils.getSetMethodByField(clazz, field);
    }

    public static Field[] getDeclaredFields(Class<?> clazz, boolean isFindParent) {
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fileds = clazz.getDeclaredFields();
        if (fileds.length > 0) {
            list.addAll(Arrays.asList(fileds));
        }
        if (isFindParent) {
            while (ClassUtils.hasCustomSuperClass(clazz)) {
                Field[] aFields = (clazz = clazz.getSuperclass()).getDeclaredFields();
                if (aFields.length <= 0) continue;
                list.addAll(Arrays.asList(aFields));
            }
        }
        return list.toArray(new Field[0]);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            while (ClassUtils.hasCustomSuperClass(clazz)) {
                clazz = clazz.getSuperclass();
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
    }

    public static Class<?> getWrapperClass(Class<?> type) {
        try {
            String className = type.getName();
            if (className.indexOf(".") == -1) {
                className = "int".equals(className) ? "java.lang.Integer" : "java.lang." + (className.charAt(0) + "").toUpperCase() + className.substring(1);
                return Class.forName(className);
            }
            return type;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object valueOf(Object value, Class<?> type) {
        Object obj = value;
        try {
            Class<?> clazz = ClassUtils.getWrapperClass(type);
            Method valueOfMethod = clazz.getDeclaredMethod("valueOf", type);
            try {
                obj = valueOfMethod.invoke(null, value);
            }
            catch (Exception e) {
                try {
                    valueOfMethod = clazz.getDeclaredMethod("valueOf", String.class);
                    obj = valueOfMethod.invoke(null, value);
                }
                catch (Exception ex) {
                    obj = 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Method getInvisibleMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> listClassNames(String packageName, boolean isFindChildPackage) {
        String packagePath;
        List<String> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames = ClassUtils.listClassNamesByFile(url.getPath(), null, isFindChildPackage);
            } else if (type.equals("jar")) {
                fileNames = ClassUtils.listClassNamesByJar(url.getPath(), isFindChildPackage);
            }
        } else {
            fileNames = ClassUtils.listClassNamesByJars(((URLClassLoader)loader).getURLs(), packagePath, isFindChildPackage);
        }
        return fileNames;
    }

    private static String getGetMethodNameByFieldName(String fieldName, String typeName) {
        if ("boolean".equals(typeName)) {
            if (fieldName.startsWith("is")) {
                return fieldName;
            }
            return "is" + ClassUtils.formatField(fieldName);
        }
        return "get" + ClassUtils.formatField(fieldName);
    }

    private static String getSetMethodNameByFieldName(String fieldName) {
        return "set" + ClassUtils.formatField(fieldName);
    }

    private static String formatField(String fieldName) {
        char first;
        if (fieldName != null && (first = fieldName.charAt(0)) >= 'A' && first <= 'z') {
            return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
        }
        return fieldName;
    }

    private static Method getSuperClassMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        while (ClassUtils.hasCustomSuperClass(clazz)) {
            clazz = clazz.getSuperclass();
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static List<String> listClassNamesByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(ClassUtils.listClassNamesByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> listClassNamesByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(ClassUtils.listClassNamesByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }

    private static List<String> listClassNamesByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }
}

