/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.io.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;

public class FileHandler {
    public static boolean isSymlink(File file) {
        return file != null && Files.isSymbolicLink(file.toPath());
    }

    public static File requireDirectoryExists(File directory) {
        FileHandler.requireExists(directory);
        FileHandler.requireDirectory(directory);
        return directory;
    }

    public static File requireDirectoryIfExists(File directory) {
        Objects.requireNonNull(directory);
        if (directory.exists()) {
            FileHandler.requireDirectory(directory);
        }
        return directory;
    }

    public static File requireExists(File file) {
        Objects.requireNonNull(file);
        if (!file.exists()) {
            throw new IllegalArgumentException("File system element for parameter does not exist: '" + file + "'");
        }
        return file;
    }

    public static File requireDirectory(File directory) {
        Objects.requireNonNull(directory);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Parameter is not a directory: '" + directory + "'");
        }
        return directory;
    }

    public static void requireFileCopy(File source, File destination) throws FileNotFoundException {
        FileHandler.requireExists(source);
        Objects.requireNonNull(destination);
    }

    public static File requireFile(File file) {
        Objects.requireNonNull(file);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Parameter is not a file: " + file);
        }
        return file;
    }

    public static void requireCanonicalPathsNotEquals(File file1, File file2) throws IOException {
        String canonicalPath = file1.getCanonicalPath();
        if (canonicalPath.equals(file2.getCanonicalPath())) {
            throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", canonicalPath, file1, file2));
        }
    }

    public static File createParentDirectories(File file) throws IOException {
        return FileHandler.mkdirs(FileHandler.getParentFile(file));
    }

    private static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static File mkdirs(File directory) throws IOException {
        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {
            throw new IOException("Cannot create directory '" + directory + "'.");
        }
        return directory;
    }

    public static File requireFileIfExists(File file) {
        Objects.requireNonNull(file);
        return file.exists() ? FileHandler.requireFile(file) : file;
    }

    public static void requireCanWrite(File file) {
        Objects.requireNonNull(file);
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File parameter is not writable: '" + file + "'");
        }
    }

    public static void requireEqualSizes(File srcFile, File destFile, long srcLen, long dstLen) throws IOException {
        if (srcLen != dstLen) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "' Expected length: " + srcLen + " Actual: " + dstLen);
        }
    }

    public static boolean checkFileSize(File file, int limitSize, String fileUnit) {
        double fileSizeCom = 0.0;
        switch (fileUnit.toUpperCase()) {
            case "B": {
                fileSizeCom = file.length();
                break;
            }
            case "K": {
                fileSizeCom = (double)file.length() / 1024.0;
                break;
            }
            case "M": {
                fileSizeCom = (double)file.length() / 1048576.0;
                break;
            }
            case "G": {
                fileSizeCom = (double)file.length() / 1.073741824E9;
                break;
            }
        }
        return (double)limitSize > fileSizeCom;
    }

    public static String getRealName(String srcPath, File file) {
        return file.getAbsolutePath().replace(srcPath + File.separator, "").replace(srcPath, "");
    }
}

