/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.io;

import cn.javaex.htool.core.io.handler.FileHandler;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        Objects.requireNonNull(file);
        if (file.exists()) {
            FileHandler.requireFile(file);
            FileHandler.requireCanWrite(file);
        } else {
            FileHandler.createParentDirectories(file);
        }
        return new FileOutputStream(file, append);
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        Objects.requireNonNull(file);
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream, String charsetName) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            charsetName = charsetName == null ? Charset.defaultCharset().name() : charsetName;
            String string = result.toString(charsetName);
            return string;
        }
        finally {
            inputStream.close();
        }
    }
}

