/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date;

import cn.javaex.htool.core.date.handler.DateHandler;
import cn.javaex.htool.core.date.handler.LocalDateHandler;
import cn.javaex.htool.core.date.handler.LocalDateTimeHandler;
import cn.javaex.htool.core.date.handler.TimeHandler;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class TimeConversion {
    protected static final int MIN_YEAR = 1990;
    protected static final String[] ZODIACS = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    protected static final int[] CONSTELLATION_DAYS = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    protected static final String[] CONSTELLATIONS = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};

    public static Date parseDate(String text, String pattern) throws ParseException {
        return new DateHandler().parse(text, pattern);
    }

    public static LocalDateTime parseLocalDateTime(String text, String pattern) {
        return new LocalDateTimeHandler().parse(text, pattern);
    }

    public static LocalDate parseLocalDate(String text, String pattern) {
        return new LocalDateHandler().parse(text, pattern);
    }

    public static String format(Date date, String pattern) throws ParseException {
        return new TimeHandler().format(date, pattern);
    }

    public static LocalDateTime parseLocalDateTime(Date date) {
        return new DateHandler().parseLocalDateTime(date);
    }

    public static LocalDate parseLocalDate(Date date) {
        return new DateHandler().parseLocalDate(date);
    }

    public static String format(LocalDateTime localDateTime, String pattern) throws ParseException {
        return new TimeHandler().format(localDateTime, pattern);
    }

    public static Date parseDate(LocalDateTime localDateTime) {
        return new LocalDateTimeHandler().parseDate(localDateTime);
    }

    public static LocalDate parseLocalDate(LocalDateTime localDateTime) {
        return new LocalDateTimeHandler().parseLocalDate(localDateTime);
    }

    public static String format(LocalDate localDate, String pattern) throws ParseException {
        return new TimeHandler().format(localDate, pattern);
    }

    public static Date parseDate(LocalDate localDate) {
        return new LocalDateHandler().parseDate(localDate);
    }

    public static LocalDateTime parseLocalDateTime(LocalDate localDate) {
        return new LocalDateHandler().parseLocalDateTime(localDate);
    }
}

