/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.cache.manager.impl;

import cn.javaex.htool.cache.manager.ICacheManager;
import cn.javaex.htool.cache.model.CacheInfo;
import cn.javaex.htool.cache.task.CacheClearTask;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManagerImpl
implements ICacheManager {
    private static final long serialVersionUID = 1L;
    public static Map<String, CacheInfo> cacheMap = new ConcurrentHashMap<String, CacheInfo>();

    @Override
    public void setCache(String key, Object cacheData, long expireTime) {
        if (expireTime == 0L) {
            expireTime = 0L;
        }
        cacheMap.put(key, new CacheInfo(cacheData, expireTime, System.currentTimeMillis()));
    }

    @Override
    public Object getCache(String key) {
        if (!this.isExistsKey(key)) {
            return null;
        }
        if (this.isExpire(key)) {
            this.removeByKey(key);
            return null;
        }
        return cacheMap.get(key).getData();
    }

    @Override
    public boolean isExistsKey(String key) {
        return cacheMap.containsKey(key);
    }

    @Override
    public void removeAll() {
        cacheMap.clear();
    }

    @Override
    public void removeByKey(String key) {
        if (this.isExistsKey(key)) {
            cacheMap.remove(key);
        }
    }

    @Override
    public boolean isExpire(String key) {
        if (!cacheMap.containsKey(key)) {
            return true;
        }
        CacheInfo cache = cacheMap.get(key);
        long expireTime = cache.getExpireTime();
        if (expireTime == 0L) {
            return false;
        }
        long lastRefreshTime = cache.getLastRefeshTime();
        return System.currentTimeMillis() - lastRefreshTime >= expireTime;
    }

    @Override
    public Set<String> getAllKeys() {
        return cacheMap.keySet();
    }

    @Override
    public Map<String, CacheInfo> getAllCacheInfos() {
        return cacheMap;
    }

    @Override
    public CacheInfo getCacheInfo(String key) {
        if (this.isExistsKey(key)) {
            return cacheMap.get(key);
        }
        return null;
    }

    static {
        CacheClearTask cacheTask = new CacheClearTask(new CacheManagerImpl());
        cacheTask.clearSchedule();
    }
}

