/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server.filter;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.server.HttpServerRequest;
import cn.hutool.http.server.HttpServerResponse;
import cn.hutool.http.server.filter.ExceptionFilter;

public class DefaultExceptionFilter
extends ExceptionFilter {
    private static final String TEMPLATE_ERROR = "<!DOCTYPE html><html><head><title>Hutool - Error report</title><style>h1,h3 {color:white; background-color: gray;}</style></head><body><h1>HTTP Status {} - {}</h1><hr size=\"1\" noshade=\"noshade\" /><p>{}</p><hr size=\"1\" noshade=\"noshade\" /><h3>Hutool</h3></body></html>";

    @Override
    public void afterException(HttpServerRequest req, HttpServerResponse res, Throwable e) {
        String content = ExceptionUtil.stacktraceToString((Throwable)e);
        content = content.replace("\n", "<br/>\n");
        content = StrUtil.format((CharSequence)TEMPLATE_ERROR, (Object[])new Object[]{500, req.getURI(), content});
        res.sendError(500, content);
    }
}

