/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.extra.mail.MailException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;

public class JakartaInternalMailUtil {
    public static InternetAddress[] parseAddressFromStrs(String[] addrStrs, Charset charset) {
        ArrayList resultList = new ArrayList(addrStrs.length);
        for (String addrStr : addrStrs) {
            Object[] addrs = JakartaInternalMailUtil.parseAddress(addrStr, charset);
            if (!ArrayUtil.isNotEmpty((Object[])addrs)) continue;
            Collections.addAll(resultList, addrs);
        }
        return resultList.toArray(new InternetAddress[0]);
    }

    public static InternetAddress parseFirstAddress(String address, Charset charset) {
        Object[] internetAddresses = JakartaInternalMailUtil.parseAddress(address, charset);
        if (ArrayUtil.isEmpty((Object[])internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new MailException(e);
            }
        }
        return internetAddresses[0];
    }

    public static InternetAddress[] parseAddress(String address, Charset charset) {
        Object[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException(e);
        }
        if (ArrayUtil.isNotEmpty((Object[])addresses)) {
            String charsetStr = null == charset ? null : charset.name();
            for (Object internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charsetStr);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MailException(e);
                }
            }
        }
        return addresses;
    }

    public static String encodeText(String text, Charset charset) {
        try {
            return MimeUtility.encodeText((String)text, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return text;
        }
    }
}

